package com.yeejoin.amos.boot.module.ugp.biz.fegin;

import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;
import com.yeejoin.amos.boot.module.ugp.api.entity.UnitLicence;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

@FeignClient(name = "TZS", path = "/tzs", configuration =
        {MultipartSupportConfig.class})
public interface TzsServiceFeignClient {

    /**
     * 根据企业名称查询许可信息
     * @param companyNames 企业名称(多个)
     * @return
     */
    @RequestMapping(value = "/baseUnitLicence/licences", method = RequestMethod.POST)
    ResponseModel<List<UnitLicence>> getLicenceByCompanyName(@RequestBody List<String> companyNames);
}
