package com.yeejoin.amos.boot.module.ccs.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 设备报警信息日志表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FireEquipmentSignalLogDto", description = "设备报警信息日志表")
public class FireEquipmentSignalLogDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "站点名称")
    private String stationName;

    @ApiModelProperty(value = "站点编码")
    private String stationCode;

    @ApiModelProperty(value = "消防设备id")
    private String fireEquipmentMrid;

    @ApiModelProperty(value = "设备名称")
    private String fireEquipmentName;

    @ApiModelProperty(value = "指标名称")
    private String fireEquipmentIndexName;

    @ApiModelProperty(value = "指标编码")
    private String fireEquipmentIndexKey;

    @ApiModelProperty(value = "报警值")
    private String fireEquipmentIndexValue;

    @ApiModelProperty(value = "建筑id（冗余字段）")
    private String fireBuildingMrid;

    @ApiModelProperty(value = "报警类型:alarm_type_fire（火灾报警）/alarm_type_trouble（故障告警）")
    private String signalType;

    @ApiModelProperty(value = "报警类型名称")
    private String signalTypeName;

    @ApiModelProperty(value = "确认状态：0-未确认 1-已确认")
    private String confirmState;

    @ApiModelProperty(value = "确认类型")
    private String confirmType;

    @ApiModelProperty(value = "确认类型名称")
    private String confirmTypeName;

    @ApiModelProperty(value = "报警原因")
    private String alarmReason;

    @ApiModelProperty(value = "处理情况")
    private String resolveResult;

    @ApiModelProperty(value = "确警人员姓名")
    private String confirmUserName;

    @ApiModelProperty(value = "确警时间")
    private Date confirmDate;

    @ApiModelProperty(value = "装备所属消防系统code（冗余字段）")
    private String systemMrids;

    @ApiModelProperty(value = "装备所属消防系统名称（冗余字段）")
    private String systemNames;

    @ApiModelProperty(value = "装备定义code（冗余字段）")
    private String equipmentDefinitionMrid;

    @ApiModelProperty(value = "装备定义名称")
    private String equipmentDefinitionName;

    @ApiModelProperty(value = "设备位置")
    private String location;

    @ApiModelProperty(value = "经度")
    private String lng;

    @ApiModelProperty(value = "纬度")
    private String lat;

    @ApiModelProperty(value = "位置经度")
    private String sourceLng;

    @ApiModelProperty(value = "位置纬度")
    private String sourceLat;

    @ApiModelProperty(value = "告警日期（冗余查询，为create_date的日期部分,如：2021-11-15")
    private String signalReportDate;

    @ApiModelProperty(value = "是否为告警信号数据")
    private Boolean isAlarm;

    @ApiModelProperty(value = "保护对象code")
    private String protectedObjectMrid;

    @ApiModelProperty(value = "保护对象名称")
    private String protectedObjectName;

    @ApiModelProperty(value = "换流站负责人")
    private String stationChargePerson;

    @ApiModelProperty(value = "负责人联系电话")
    private String chargePersonPhone;
}
