package com.yeejoin.amos.boot.module.ccs.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ccs.api.dto.BaseDto;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireBuildingDto;
import com.yeejoin.amos.boot.module.ccs.api.entity.FireBuilding;
import com.yeejoin.amos.boot.module.ccs.api.mapper.FireBuildingMapper;
import com.yeejoin.amos.boot.module.ccs.api.service.IFireBuildingService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 消防建筑表服务实现类
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Service
public class FireBuildingServiceImpl extends BaseService<FireBuildingDto, FireBuilding, FireBuildingMapper> implements IFireBuildingService {

    public static final String ROOT_ID = "-1";
    /**
     * 分页查询
     */
    public Page<FireBuildingDto> queryForFireBuildingPage(Page<FireBuildingDto> page, @Condition(Operator.like) String name, @Condition String stationCode, String type) {
        return this.queryForPage(page, "create_date", false, name, stationCode, type);
    }


    public List<FireBuildingDto> buildingTree(String stationCode) {
        List<FireBuildingDto> dtoList = this.queryForList("create_date", true, stationCode);
        FireBuildingDto parentNode = new FireBuildingDto();
        parentNode.setId(ROOT_ID);
        parentNode.setName("全部建筑");
        parentNode.setMrid(ROOT_ID);
        parentNode.setTreeMrids(ROOT_ID);
        List<FireBuildingDto> childrenNode = dtoList.stream().filter(d -> StringUtils.isBlank(d.getParentMrid()) || "0".equals(d.getParentMrid()) || "-1".equals(d.getParentMrid())).peek(s -> s.setChildren(this.getChildren(s.getMrid(), dtoList))).sorted(Comparator.comparing(BaseDto::getCreateDate)).collect(Collectors.toList());
        parentNode.setChildren(childrenNode);
        return Collections.singletonList(parentNode);
    }

    private List<FireBuildingDto> getChildren(String mrid, List<FireBuildingDto> dtoList) {
        return dtoList.stream().filter(d -> StringUtils.isNotBlank(d.getParentMrid()) && d.getParentMrid().equals(mrid)).
                peek(s -> s.setChildren(this.getChildren(s.getMrid(), dtoList))).
                sorted(Comparator.comparing(BaseDto::getCreateDate)).collect(Collectors.toList());
    }

    public List<FireBuildingDto> stationBuildingTree(String stationCode) {
        List<FireBuildingDto> dtoList = this.queryForList("create_date", true, stationCode);
        // 根据换流站code分组list
        Map<String, List<FireBuildingDto>> stationMap = dtoList.stream().collect(Collectors.groupingBy(f  -> f.getStationName()+"_"+f.getStationCode()));
        return stationMap.keySet().stream().map(key -> {
            FireBuildingDto parentNode = new FireBuildingDto();
            String[] temp = key.split("_");
            String name = temp[0];
            String code = temp[1];
            parentNode.setStationCode(code);
            parentNode.setStationName(name);
            parentNode.setId(code);
            parentNode.setType("station");
            parentNode.setName(name);
            List<FireBuildingDto> childrenNode = stationMap.get(key).stream().filter(d -> StringUtils.isBlank(d.getParentMrid()) || "0".equals(d.getParentMrid()) || "-1".equals(d.getParentMrid())).
                    peek(s -> s.setChildren(this.getChildren(s.getMrid(), dtoList))).
                    sorted(Comparator.comparing(BaseDto::getCreateDate)).collect(Collectors.toList());
            parentNode.setChildren(childrenNode);
            return parentNode;
        }).collect(Collectors.toList());
    }
    
    public Map<String, Object> getBuildingByMrid(String mrid){
    	Map<String,Object> result = new HashMap<String, Object>();
    	List<FireBuildingDto> fireBuildings = this.baseMapper.getFireBuildingByMridIntreeMrids(mrid);
    	if(!ObjectUtils.isEmpty(fireBuildings)){
    		FireBuildingDto fireBuilding = fireBuildings.get(0);
    		result = JSON.parseObject(JSON.toJSONString(fireBuilding), HashMap.class);
    		if(!ObjectUtils.isEmpty(fireBuilding.getAttribute())){
        		HashMap<String, Object> attribute = JSON.parseObject(fireBuilding.getAttribute().toString(), HashMap.class);
        		result.putAll(attribute);
    		}
    	}
		return result;
    }
}