package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jcs.api.dto.ControllerDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.Controller;
import com.yeejoin.amos.boot.module.jcs.api.entity.ControllerLog;
import com.yeejoin.amos.boot.module.jcs.api.enums.ControllerGroupEnum;
import com.yeejoin.amos.boot.module.jcs.api.enums.ControllerTypeEnum;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.ControllerEquipServiceImpl;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.ControllerLogServiceImpl;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.ControllerServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.*;

/**
 * 联动控制器
 *
 * @author system_generator
 * @date 2021-12-03
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/controller")
public class ControllerController extends BaseController {

    @Autowired
    ControllerServiceImpl controllerServiceImpl;


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "更新联动控制器状态", notes = "更新联动控制器状态")
    @PostMapping(value = "/updateControllerState")
    public ResponseModel<Object> updateControllerState(@RequestBody Controller[] controllers) {
        return ResponseHelper.buildResponse(controllerServiceImpl.changeControllerState(controllers));
    }

    /**
     * 列表全部数据查询
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<Object> selectForList() {
        List<Controller> controllerList = controllerServiceImpl.list();
        List<Map<String, Object>> controllerStations = new ArrayList<>();
        //分类联动控制站点
        HashSet<Integer> controllerStation = new HashSet<>();
        controllerList.forEach(controller -> controllerStation.add(Integer.valueOf(controller.getStation())));
        controllerStation.forEach(station -> {
            ArrayList<ControllerDto> controllerDtos = new ArrayList<>();
            controllerList.forEach(controller -> {
                if (station.equals(Integer.valueOf(controller.getStation()))) {
                    ControllerDto controllerDto = new ControllerDto();
                    ControllerTypeEnum anEnum = ControllerTypeEnum.getEnum(controller.getType());
                    BeanUtils.copyProperties(controller, controllerDto);
                    controllerDto.setTypeEnum(anEnum);
                    controllerDto.setTypeDescription(anEnum.getName());
                    controllerDtos.add(controllerDto);
                }
            });
            //类型排序
            controllerDtos.sort(Comparator.comparingInt(o -> o.getTypeEnum().getSort()));
            HashMap<String, Object> result = new HashMap<>();
            result.put("groupEnum", ControllerGroupEnum.getEnum(station));
            result.put("groupName", Objects.requireNonNull(ControllerGroupEnum.getEnum(station)).getName());
            result.put("controllers", controllerDtos);
            controllerStations.add(result);
        });
        //大队排序
        controllerStations.sort(Comparator.comparingInt(o -> ((ControllerGroupEnum) o.get("groupEnum")).getOrder()));
        return ResponseHelper.buildResponse(controllerStations);
    }
}

