package com.yeejoin.amos.boot.module.jcs.biz.service.impl;


import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.common.api.feign.JcsControlServerClient;
import com.yeejoin.amos.boot.module.jcs.api.entity.Controller;
import com.yeejoin.amos.boot.module.jcs.api.service.IControllerEquipService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.yeejoin.amos.boot.module.jcs.api.dto.ControllerEquipDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.ControllerEquip;
import com.yeejoin.amos.boot.module.jcs.api.mapper.ControllerEquipMapper;

/**
 * <pre>
 * 控制器设备 服务实现类
 * </pre>
 *
 * @author gwb
 * @version $Id: ControllerEquipServiceImpl.java, v 0.1 2021年8月20日 上午10:16:33 gwb Exp $
 */
@Service
public class ControllerEquipServiceImpl extends BaseService<ControllerEquipDto, ControllerEquip, ControllerEquipMapper> implements IControllerEquipService {
    @Autowired
    JcsControlServerClient jcsControlServerClient;

    public List<ControllerEquipDto> queryAllForList() {
        return this.queryForList("", false);
    }

    /**
     * 改变警铃状态 0关闭，1开启
     */
    @Async
    public void changeBell(Controller controller, String type) {
        if (controller == null) return;
        List<ControllerEquip> list = getControllerEquips(controller);
        list.forEach(controllerEquip -> jcsControlServerClient.sendBellAction(controllerEquip.getNum(), type));
    }

    /**
     * 改变广播状态 0关闭，1开启
     */
    @Async
    public void changeBroadcast(Controller controller, String type) {
        if (controller == null) return;
        List<ControllerEquip> list = getControllerEquips(controller);
        list.forEach(controllerEquip -> jcsControlServerClient.sendFileAction(controllerEquip.getNum(), ""));
    }

    /**
     * 改变车库门状态 0关闭，1开启
     */
    @Async
    public void changeDoor(Controller controller, String type) {
        if (controller == null) return;
        List<ControllerEquip> list = getControllerEquips(controller);
        list.forEach(controllerEquip -> jcsControlServerClient.writeStateAction(controller.getIp(), controller.getPort(), Integer.parseInt(controllerEquip.getNum()), type));
    }

    private List<ControllerEquip> getControllerEquips(Controller controller) {
        LambdaQueryWrapper<ControllerEquip> wrapper = new LambdaQueryWrapper<ControllerEquip>().eq(ControllerEquip::getControllerSeq, controller.getSequenceNbr());
        return list(wrapper);
    }
}
