package com.yeejoin.amos.boot.module.common.api.dto;

import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.Date;

/**
 * @author Administrator
 * 用户操作日志
 */

@Data
@Document(indexName = "user_operate_log", shards = 2)
public class ESUserOperateLogDto {

    @Id
    private String id;

    @Field(type = FieldType.Text)
    private String methodName;

    @Field(type = FieldType.Text)
    private String remoteIp;

    @Field(type = FieldType.Text)
    private String methodLabel;

    @Field(type = FieldType.Text)
    private String params;

    @Field(type = FieldType.Text)
    private String result;

    @Field(type = FieldType.Keyword)
    private String traceId;

    @Field(type = FieldType.Keyword)
    private String userId;

    @Field(type = FieldType.Long)
    private Long createDate;

    @Field(type = FieldType.Text)
    private String serviceIp;

    @Field(type = FieldType.Text)
    private String serviceName;

    @Field(type = FieldType.Long)
    private Long requestTimeMills;

    @Field(type = FieldType.Keyword)
    private String loginId;

    @Field(type = FieldType.Text)
    private String token;

    @Field(type = FieldType.Text)
    private String appKey;

    @Field(type = FieldType.Text)
    private String product;

    @Field(type = FieldType.Text)
    private String requestDate;
}
