package com.yeejoin.amos.api.openapi.face.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.cylinder.api.dto.CylinderFillingMessageModel;
import com.yeejoin.amos.boot.module.cylinder.api.dto.PageParam;
import com.yeejoin.amos.boot.module.cylinder.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.cylinder.api.entity.CylinderFillingMessageEntity;
import com.yeejoin.amos.boot.module.cylinder.api.mapper.CylinderFillingMessageMapper;
import com.yeejoin.amos.boot.module.cylinder.api.mapper.TzBaseEnterpriseInfoMapper;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
public class TmCylinderFillingMessageService extends BaseService<CylinderFillingMessageModel, CylinderFillingMessageEntity, CylinderFillingMessageMapper> {

    private final TzBaseEnterpriseInfoMapper tzBaseEnterpriseInfoMapper;

    public TmCylinderFillingMessageService(TzBaseEnterpriseInfoMapper tzBaseEnterpriseInfoMapper) {
        this.tzBaseEnterpriseInfoMapper = tzBaseEnterpriseInfoMapper;
    }

    public IPage<CylinderFillingMessageModel> getUploadCylinderLogs(PageParam pageParam, String regionCode) {
        CompanyModel result = Privilege.companyClient.queryByCompanyCode(regionCode).getResult();
        Page<CylinderFillingMessageModel> page = new Page<>(pageParam.getCurrent(), pageParam.getSize());
        if(result != null){
            IPage<CylinderFillingMessageModel> uploadCylinderLogsByOrgCode = getUploadCylinderLogsByOrgCode(page, result.getOrgCode());
            List<String> appIds = uploadCylinderLogsByOrgCode.getRecords().stream().map(CylinderFillingMessageModel::getAppId).collect(Collectors.toList()).stream().filter(x -> !ValidationUtil.isEmpty(x)).distinct().collect(Collectors.toList());
            if(!appIds.isEmpty()){
                List<TzBaseEnterpriseInfoDto> tzBaseEnterpriseInfoDtos = tzBaseEnterpriseInfoMapper.queryByAppId(appIds);
                if (!ValidationUtil.isEmpty(tzBaseEnterpriseInfoDtos)){
                    Map<String, String> map = tzBaseEnterpriseInfoDtos.stream().collect(Collectors.toMap(TzBaseEnterpriseInfoDto::getAppId, TzBaseEnterpriseInfoDto::getUseUnitCode));
                    uploadCylinderLogsByOrgCode.getRecords().forEach(x -> {
                        x.setUseUnitCode(map.get(x.getAppId()));
                    });
                }
            }
        }
        return page;
    }

    public IPage<CylinderFillingMessageModel> getUploadCylinderLogsByOrgCode(Page<CylinderFillingMessageModel> page, @Condition(Operator.likeRight) String orgCode) {
        return queryForPage(page, null, false, orgCode);
    }
}
