package com.yeejoin.amos.boot.module.elevator.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author ky
 * @date 2023-07-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_base_enterprise_info")
@ApiModel(value = "BaseEnterpriseInfo对象", description = "BaseEnterpriseInfo对象")
public class EnterpriseInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "统一社会信用代码")
    @TableField("use_code")
    private String useCode;

    @ApiModelProperty(value = "维护保养单位名称")
    @TableField("use_unit")
    private String useUnit;

    @ApiModelProperty(value = "省份")
    @TableField("province")
    private String province;

    @ApiModelProperty(value = "地市")
    @TableField("city")
    private String city;

    @ApiModelProperty(value = "区县")
    @TableField("district")
    private String district;

    @ApiModelProperty(value = "区域代码")
    @TableField("supervise_code")
    private String regionCode;

    @ApiModelProperty(value = "地址(详细地址，包括道路、门牌号码)")
    @TableField("address")
    private String address;

    @ApiModelProperty(value = "经度")
    @TableField("longitude")
    private String longitude;

    @ApiModelProperty(value = "纬度")
    @TableField("latitude")
    private String latitude;

    @ApiModelProperty(value = "法人")
    @TableField("legal_person")
    private String legalPerson;

    @ApiModelProperty(value = "法人电话/注册电话")
    @TableField("legal_phone")
    private String legalPersonPhone;

    @ApiModelProperty(value = "值班电话")
    @TableField("contact_phone")
    private String dutyPhone;

    @ApiModelProperty(value = "主要负责人1")
    @TableField("safety_one")
    private String principalFirst;

    @ApiModelProperty(value = "主要负责人1手机号码")
    @TableField("safety_one_phone")
    private String principalFirstPhone;

    @ApiModelProperty(value = "主要负责人1id")
    @TableField("safety_one_id")
    private Long principalFirstId;

    @ApiModelProperty(value = "主要负责人2")
    @TableField("safety_two")
    private String principalSecond;

    @ApiModelProperty(value = "主要负责人2手机号码")
    @TableField("safety_two_phone")
    private String principalSecondPhone;

    @ApiModelProperty(value = "主要负责人2id")
    @TableField("safety_two_id")
    private Long principalSecondId;

    @ApiModelProperty(value = "单位类型")
    @TableField("unit_type")
    private String unitType;

    @TableField(exist = false)
    private List<String> ids;
}
