package com.yeejoin.amos.boot.module.jg.biz.reminder.biz.newProject;

import cn.hutool.core.bean.BeanUtil;
import com.yeejoin.amos.boot.module.jg.api.dto.ReminderItemDto;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.reminder.core.DefaultReminder;
import com.yeejoin.amos.boot.module.jg.biz.reminder.dto.MatchItemDto;
import com.yeejoin.amos.boot.module.jg.biz.reminder.service.CommonReminderService;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectContraption;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 管道创建编辑-提醒处理器
 */
@Component
public class NewProjectReminderAdapter extends DefaultReminder {

    private final NewProjectParseService newProjectParseService;

    public NewProjectReminderAdapter(ApplicationContext applicationContext, NewProjectParseService newProjectParseService) {
        super(applicationContext);
        this.newProjectParseService = newProjectParseService;
    }


    @Override
    protected List<ReminderItemDto> realtimeParse(String bizId) {
        // 创建后，评分使用
        return CommonReminderService.setProjectReminderItemRealTime(bizId, newProjectParseService.getIdxBizJgProjectContraptionServiceImpl());
    }

    @Override
    protected List<ReminderItemDto> jsonParse(String bizId, Map<String, Object> formData) {
        //  新增 + 编辑的保存使用
        IdxBizJgProjectContraption projectContraption = CommonReminderService.geEquipInfoFromJson(formData, IdxBizJgProjectContraption.class);
        ReminderItemDto reminderItemDto = new ReminderItemDto();
        reminderItemDto.setEquipId(StringUtils.isEmpty(bizId) ? "1" : bizId);
        reminderItemDto.setEquipNo(projectContraption.getProjectContraptionNo());
        reminderItemDto.setEquipName(projectContraption.getProjectContraption());
        reminderItemDto.setDetailData(BeanUtil.beanToMap(projectContraption));
        return Collections.singletonList(reminderItemDto);
    }

    @Override
    protected MatchItemDto setMatchItem(String bizId, Map<String, Object> formData) {
        // 新增 + 编辑的保存使用
        MatchItemDto matchItemDto = MatchItemDto.builder().build();
        IdxBizJgProjectContraption projectContraption = CommonReminderService.geEquipInfoFromJson(formData, IdxBizJgProjectContraption.class);
        matchItemDto.setEquList(projectContraption.getEquList());
        matchItemDto.setEquCategory(projectContraption.getEquCategory());
        matchItemDto.setEquDefine(projectContraption.getEquDefine());
        matchItemDto.setIsRegister(!StringUtils.isEmpty(bizId) && projectContraption.getIsIntoManagement() && StringUtils.isNotEmpty(projectContraption.getUseRegistrationCode()));
        matchItemDto.setRegType(StringUtils.isNotEmpty(bizId) ? CommonReminderService.getRegTypeByDataSource(projectContraption.getDataSource()) : CommonReminderService.getRegTypeForInsert(formData));
        return matchItemDto;
    }

    @Override
    protected MatchItemDto setMatchItem(String bizId) {
        IdxBizJgProjectContraption projectContraption = newProjectParseService.getIdxBizJgProjectContraptionServiceImpl().getById(bizId);
        // 等级 + 详情使用
        MatchItemDto matchItemDto = MatchItemDto.builder().build();
        return CommonReminderService.setMatchItemForProject(matchItemDto, projectContraption);
    }


    @Override
    public String supportBizType() {
        return BusinessTypeEnum.JG_NEW_PROJECT.name();
    }
}
