package com.yeejoin.amos.api.openapi.enums;


import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@AllArgsConstructor
@Getter
public enum FillingBeforeFieldEnum {
    sequenceCode(true, true),
    fillingBeforeId(true, true),
    creditCode(true, false),
    fillingUnitName(true, false),
    inspectorUser(true, false),
    inspectionDate(true, false),
    isValid(true, false),
    same(true, false),
    isRegulations(true, false),
    isComplianceWithGBT(true, false),
    haveStillPressure(true, false),
    isComplete(true, false),
    haveSecurityDocuments(true, false),
    fillBeforeItem(true, false),
    checkResults(true, false),
    nonconformances(true, false),
    syncDate(true, false),
    syncState(true, false);

    private final boolean isRequire;
    private final boolean isUnique;

    public static List<String> getAllRequireKeys() {
        return Arrays.stream(values()).filter(e -> e.isRequire).map(Enum::name).collect(Collectors.toList());
    }

    public  static List<String> getAllUniqueKeys() {
        return Arrays.stream(values()).filter(e -> e.isUnique).map(Enum::name).collect(Collectors.toList());
    }
}
