package com.yeejoin.amos.api.openapi.face.orm.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import java.util.Date;
@EqualsAndHashCode(callSuper = true)
@Data
public abstract class AbstractBaseEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "同步时间 yyyy-MM-dd HH24:mi:ss")
	private Date syncDate;

	@ApiModelProperty(value = "0-新增 1-更新 2-删除")
	private Integer syncState;

	@ApiModelProperty(value = "对接公司编码")
	private String appId;

	@ApiModelProperty(value = "数据完整度")
	private Double integrity;

	@ApiModelProperty(value = "对接接口版本")
	private String version = "v1";

	@ApiModelProperty(value = "更新人员")
	private String recUserName;
}
