package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.module.jcs.api.dto.FusionDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.VoiceRecordFileDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertCalled;
import com.yeejoin.amos.boot.module.jcs.api.entity.VoiceRecordFile;
import com.yeejoin.amos.boot.module.jcs.api.service.IAlertCalledService;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.AlertCalledServiceImpl;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.FusionServiceImpl;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.VoiceRecordFileServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 融合终端Controller
 *
 * @author xl
 * @date 2021-11-25
 */
@RestController
@Api(tags = "融合终端Api")
@RequestMapping(value = "/fusion")
public class FusionController extends BaseController {

    @Autowired
	FusionServiceImpl fusionService;

	@Autowired
	VoiceRecordFileServiceImpl voiceRecordFileService;
	@Autowired
	IAlertCalledService iAlertCalledService;
	/**
	 * 查询用户详情
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "查询用户详情",   notes = "查询用户详情")
	@GetMapping(value = "/getEmployeeByEID")
	public ResponseModel<JSONObject> getEmployeeByEID(@RequestParam(value = "employeeId", required = true) String employeeId) {
		JSONObject jsonObject = fusionService.getEmployeeByEID(employeeId);
		return ResponseHelper.buildResponse(jsonObject);
	}

	/**
	 *
	 *
	 * 800M40M	录音文件
	 *
	 * */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "get",value = "800M40M录音文件",   notes = "800M40M录音文件")
	@GetMapping  (value = "/getCarList/{id}")
	public ResponseModel<JSONObject> getCarList(  @PathVariable Long id

	) {

      //获取警情
		AlertCalled alertCalled=iAlertCalledService.getAlertCalledById(id);
		SimpleDateFormat formatter= new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");


		String beginTime=null;
		String endTime=null;
		//获取警情上报时间
		 beginTime=formatter.format(alertCalled.getCallTime());
		if(alertCalled.getAlertStatus()){
			endTime=formatter.format(alertCalled.getUpdateTime());
		}else{
			endTime=formatter.format(new Date());
		}

		JSONObject carList = fusionService.selectAudioVideoRecords(    1,
						1000,
						beginTime,
						endTime,
						null,
						null,
						null,
						9);
		return ResponseHelper.buildResponse(carList);
	}






	/**
	 * 查询车辆
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "获取车辆信息",   notes = "获取车辆信息")
	@GetMapping(value = "/getCarList")
	public ResponseModel<List> getCarList(@RequestParam(value = "hasFusion", required = false) Boolean hasFusion) {
		List<FusionDto> carList = voiceRecordFileService.getCarList(hasFusion);
		return ResponseHelper.buildResponse(carList);
	}

	/**
	 * 查询单兵
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "获取单兵信息",   notes = "获取单兵信息")
	@GetMapping(value = "/getSinglePawnList")
	public ResponseModel<List> getSinglePawnList(@RequestParam(value = "hasFusion", required = false) Boolean hasFusion) {
		List<FusionDto> singlePawnList = voiceRecordFileService.getSinglePawnList(hasFusion);
		return ResponseHelper.buildResponse(singlePawnList);
	}
}
