package com.yeejoin.amos.boot.module.common.api.feign;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

@FeignClient(name = "${Knowledgebase.fegin.name}",path = "knowledgebase" ,configuration = {MultipartSupportConfig.class})
public interface KnowledgebaseFeignClient {
	
		 @RequestMapping(value = "/v1/tagvalue/getAll/tegartValue", method = RequestMethod.GET)
		 ResponseModel<Object>  getAllTegartValue(@RequestParam String value) ;
		 
		 @RequestMapping(value = "/v1/taginstance/find/{id}", method = RequestMethod.GET)
		 ResponseModel<Object> findById(@PathVariable("id") Long id);
		 
		 @RequestMapping(value = "/v1/doccontent/getSimpleDetail/{sequenceNbr}", method = RequestMethod.GET)
		 ResponseModel<Object> getSimpleDetail(@PathVariable(value = "sequenceNbr") String sequenceNbr);
		 
		 @RequestMapping(value = "/v1/taginstance/targetSeq/{id}", method = RequestMethod.GET)
		 ResponseModel<Object> queryListByTargetSeq(@PathVariable("id") Long id);
		 
		 @RequestMapping(value = "/v1/tagvalue/getOne/", method = RequestMethod.GET)
		 ResponseModel<Object> queryByInstance(@RequestParam Long id) ;
		 
		  @RequestMapping(value = "/v1/taginstance/getTarget/byName", method = RequestMethod.GET)
		 ResponseModel<Object> queryListByTagName(@RequestParam String name);
		 
}
