package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.SystemDic;
import com.yeejoin.equipmanage.common.utils.NameUtils;
import com.yeejoin.equipmanage.service.ISystemDicService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;


/**
 * 数据字典
 *
 * @author wujiang
 * @date 2020-07-07
 */
@RestController
@Api(tags = "数据字典Api")
@RequestMapping(value = "/system-dic", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class SystemDicController {

  @Autowired
  ISystemDicService iSystemDicService;


    /**
    * 新增数据字典
    * @return
    */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "新增数据字典", notes = "新增数据字典")
    public boolean saveSystemDic(HttpServletRequest request, @RequestBody SystemDic systemDic){
    return iSystemDicService.save(systemDic);
    }

    /**
    * 根据id删除
    * @param id
    * @return
    */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id){
    return iSystemDicService.removeById(id);
    }


    /**
    * 修改数据字典
    * @return
    */
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "修改数据字典", notes = "修改数据字典")
    public boolean updateByIdSystemDic(HttpServletRequest request, @RequestBody SystemDic systemDic){
    return iSystemDicService.updateById(systemDic);
    }



    /**
   * 根据id查询
   * @param id
   * @return
   */
   @RequestMapping(value = "/{id}", method = RequestMethod.GET)
       @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
   public SystemDic selectById(HttpServletRequest request, @PathVariable Long id){
      return iSystemDicService.getById(id);
   }

   /**
    * 根据类型查询
    * @return
    */
   @RequestMapping(value = "/listByType", method = RequestMethod.GET)
       @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表查询", notes = "列表查询")
   public List<SystemDic> listDic(String dicType) {
        return iSystemDicService.findAllByType(dicType);
   }


  /**
  * 列表分页查询
  * @return
  */
  @RequestMapping(value = "/list", method = RequestMethod.GET)
      @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
  public IPage<SystemDic> listPage(String pageNum,String pageSize,
    SystemDic systemDic){

    Page<SystemDic> pageBean;
    QueryWrapper<SystemDic> systemDicQueryWrapper = new QueryWrapper<>();
    Class<? extends SystemDic> aClass = systemDic.getClass();
    Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
        try {
            field.setAccessible(true);
            Object o = field.get(systemDic);
            if (o != null) {
                Class<?> type = field.getType();
                String name = NameUtils.camel2Underline(field.getName());
                if (type.equals(Integer.class)) {
                Integer fileValue = (Integer) field.get(systemDic);
                systemDicQueryWrapper.eq(name, fileValue);
                } else if (type.equals(Long.class)) {
                Long fileValue = (Long) field.get(systemDic);
                systemDicQueryWrapper.eq(name, fileValue);
                } else if (type.equals(String.class)) {
                String fileValue = (String) field.get(systemDic);
                systemDicQueryWrapper.eq(name, fileValue);
                } else {
                String fileValue = (String) field.get(systemDic);
                systemDicQueryWrapper.eq(name, fileValue);
            }
          }
        }catch (Exception e) {
        }
    });
    IPage<SystemDic> page;
    if (StringUtils.isBlank(pageNum)  ||StringUtils.isBlank(pageSize)) {
        pageBean = new Page<>(0, Long.MAX_VALUE);
    }else{
        pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
    }
    page = iSystemDicService.page(pageBean, systemDicQueryWrapper);
    return page;
  }
}


