package com.yeejoin.amos.boot.module.common.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.biz.common.annotations.DataAuth;
import com.yeejoin.amos.boot.module.common.api.dto.*;
import com.yeejoin.amos.boot.module.common.api.entity.DynamicFormInstance;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;

import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;


/**
* 机构/部门/人员表 Mapper 接口
*
* @author tb
* @date 2021-06-18
*/
public interface OrgUsrMapper extends BaseMapper<OrgUsr> {
    String selectUpUnitByParam(@Param("id")String biz_org_code);
    
    int selectPersonListCount(@Param("map")Map<String, Object> map);

    List<Map<String, Object>> selectPersonList(@Param("map")Map<String, Object> map);

    //BUG 2880  by litw start 2021年9月16日
    List<OrgUsr> selectAllChildrenList(@Param("map")Map<String, Object> map);



    int getUserByPeopleTypeCount(@Param("map")Map<String, Object> map);

    List<Map<String, Object>> getUserByPeopleType(@Param("map")Map<String, Object> map);



	List<OrgUsr> selectCompanyDepartmentMsg();

	List<Map<String, Object>> selectPersonAllList(Map<String, Object> map);

	List<OrgUsr> queryOrgUsrListByBizOrgCode(String bizOrgCode);

    List<OrgPersonExcelDto> queryOrgPersonDtoList(boolean isDelete);

    /**
     * 根据id查询当前单位下的所有子单位、部门
     *
     * @param orgUserId
     * @return
     */
    List<OrgUsr> listOrgUserById(Long orgUserId);

    List<OrgUsrDto> selectOrgUsrList (@Param("seq") Long seq);

    /**
     * * @param null
     * @return
     * <PRE>
     * author tw
     * date 2021/7/20
     * </PRE>
     * 指挥重点单位资源
     */
    List<CompanyDto> listContractDto(@Param("pageNum")int pageNum, @Param("pageSize")int pageSize, @Param("par") RequestData par);

    Integer listContractDtoCount(@Param("par")RequestData par);
    /**
     * 获取机场单位树，包含对应单位下部门的数量
     * @return
     */
    List<OrgUsrTreeDto> getCompanyAndCountDepartment();


    List< OrgUsrzhDto> getOrgUsrzhDto(@Param("bizOrgName")String bizOrgName);


    List< Map<String,Object>> getparent();
    List< OrgUsrExcelDto> exportToExcel(String parentId ,String bizOrgCode,String internalPositionCode ,String positionType);

    /**
     * 查询单位基本信息列表和单位下所有的重点部位数量。
     */
    List<CheckObjectDto> getCompanyAndKeySite(Long companyId);

    List<UserUnitDto>  getUserUnit(String id, String type, String code);

    List<UserDto> getUserInfo(String id, String type, String code, String[] fieldCode);

    /**
     * 导出机场单位带过滤      bug2657 by kongfm
     * @param parentId
     * @return
     */
    List< OrgUsrExcelDto> exportPersonToExcelByParentId(Long parentId);

    int  amosIdExist(@Param("amosId") String amosId, @Param("orgUsrId") String orgUsrId);

    int  amosIdExistTeam(String amosId);


    void updatelistByParentId(String codex, String code);
    
    List< Map<String,String>>   getPersonSimpleDetail();

    List<Map<String, Long>> countDeptByCompanyId(@Param("companyIdList") List<String> companyIdList);

    List<Map<String,Object>> queryCompanyId(String bizOrgName,@Param("codes")List<String> codes);

    List<Map<String,Object>> queryCompanyIdNew(String bizOrgName);

    OrgUsr queryByUserId(@Param("userId")Long userId);

    List<OrgUsr> companyTreeByUserAndType(Map<String, Object> param);

    List<OrgUsr> equipCompanyExport(String bizOrgCode);

    OrgUsr queryBySequenceNbr(@Param("parentId") String parentId);

    List<OrgUsr> companyDeptListWithPersonCount(Map<String, Object> param);

    List<OrgUsr> companyTreeByUser(String bizOrgCode);

    Map<String,String> selectPersonone(@Param("name")String name ,@Param("id")Long id);

    List<OrgUsr> listByOrgTypes(@Param("orgTypeList") List<String> orgTypeList,@Param("bizOrgCode") String bizOrgCode);

    String getParentList(@Param("id") String id);

    List<OrgUsr> selectPersonListByCompanyIdList(@Param("companyIdList") List<String> companyIdList);

    Map<String,String> getManagePerson(@Param("name")String name ,@Param("ids")List<Long> ids);

    /**
     * 检查身份证号码是否存在
     * @param certificatesNumber
     * @param orgUserId
     * @return
     */
    List<DynamicFormInstance> checkCertificatesNumber(String certificatesNumber, Long orgUserId);

    OrgUsr queryByCompanyCode(@Param("companyCode") String companyCode);

    List<OrgUsrSyncDto> getOrgUsrSyncDataList(Map<String, Object> map);

    List<OrgUsr> companyUserTreeByUserAndType(Map<String, Object> param);
    List<OrgUsr> companyUserTreeByUserAndTypeALL(@Param("bizorgcode") String bizorgcode);

    List<Map<String, Object>> getFireProtectionAndMaintenance();
}
