package com.yeejoin.equipmanage.controller;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.equipmanage.common.utils.*;
import com.yeejoin.equipmanage.config.PersonIdentify;
import com.yeejoin.equipmanage.fegin.IotFeign;
import com.yeejoin.equipmanage.mapper.FireFightingSystemMapper;
import com.yeejoin.equipmanage.service.IEquipmentSpecificAlarmService;
import com.yeejoin.equipmanage.service.IFireFightingSystemService;
import com.yeejoin.equipmanage.service.ISupervisionVideoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.DateTimeUtil;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@RestController
@Api(tags = "监盘总览组态需求 -- API")
@RequestMapping(value = "/supervisionConfigure", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class SupervisionConfigureController extends AbstractBaseController {

    @Autowired
    private FireFightingSystemMapper fireFightingSystemMapper;

    @Autowired
    private IFireFightingSystemService iFireFightingSystemService;

    @Autowired
    private IEquipmentSpecificAlarmService equipmentSpecificAlarmService;

    @Autowired
    private IotFeign iotFeign;

    @Autowired
    private ISupervisionVideoService supervisionVideoService;

    @Value("${equipment.pressurepump.start}")
    private String pressurePumpStart;

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "监盘概览水源信息")
    @GetMapping("/getWaterInfo")
    public ResponseModel getWaterInfo(CommonPageable commonPageable, @RequestParam(required = false) String bizOrgCode) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        if (StringUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        }
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        return CommonResponseUtil.success(fireFightingSystemMapper.getWaterInfoBySuper(page, bizOrgCode));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "监盘概览泡沫罐和水箱信息（监盘概览）")
    @GetMapping("/getFoamTankBySuper")
    public ResponseModel getFoamTankBySuper(CommonPageable commonPageable, @RequestParam(required = false) String bizOrgCode) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        if (StringUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        }
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        return CommonResponseUtil.success(fireFightingSystemMapper.getFoamTankBySuper(page, bizOrgCode));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "监盘概览管网压力信息（监盘概览）")
    @GetMapping("/getPipeNetworkBySuper")
    public ResponseModel getPipeNetworkBySuper(CommonPageable commonPageable, @RequestParam(required = false) String bizOrgCode) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        if (StringUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        }
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        return CommonResponseUtil.success(fireFightingSystemMapper.getPipeNetworkBySuper(page, bizOrgCode));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "监盘概览水池装置进水流量信息（监盘概览）")
    @GetMapping("/getInfluentFlowBySuper")
    public ResponseModel getInfluentFlowBySuper(CommonPageable commonPageable, @RequestParam(required = false) String bizOrgCode) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        if (StringUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        }
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        return CommonResponseUtil.success(fireFightingSystemMapper.getInfluentFlowBySuper(page, bizOrgCode));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取某站下装备数量、摄像头数量（监盘概览）")
    @GetMapping("/statisticsBySuper")
    public ResponseModel statisticsByStation(@RequestParam(required = false) String bizOrgCode) {

        if (ObjectUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
            if (!ValidationUtil.isEmpty(personIdentity)) {
                bizOrgCode = personIdentity.getBizOrgCode();
            }
        }
        if (ObjectUtils.isEmpty(bizOrgCode)) {
            return CommonResponseUtil.success(null);
        }
        return CommonResponseUtil.success(fireFightingSystemMapper.statisticsByStation(bizOrgCode));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "【监盘总览-排油系统信息】获取系统设备状态（根据系统编码查询）")
    @GetMapping("/getEquipmentStateBySuper")
    public ResponseModel getEquipmentStateBySuper(@RequestParam(required = false) String systemCode, CommonPageable commonPageable) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        Page result = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        HashMap<String, Object> hashMap = new HashMap<>();
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            String bizOrgCode = personIdentity.getBizOrgCode();
            if (StringUtils.isNotBlank(bizOrgCode)) {
                hashMap.put("bizOrgCode", bizOrgCode);
            }
            if (bizOrgCode == null) {
                return CommonResponseUtil.success(null);
            }
        }
        if (StringUtils.isNotBlank(systemCode)) {
            hashMap.put("systemCode", systemCode);
        } else {
            throw new BadRequest("系统编码不能为空");
        }
        return CommonResponseUtil.success(iFireFightingSystemService.equipmentStateBySuper(result, hashMap));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "【监盘总览-排油系统信息】获取系统工作状态（根据系统编码查询）")
    @GetMapping("/getSystemStatusBySuper")
    public ResponseModel getSystemStatusBySuper(@RequestParam(required = false) String systemCode) {
        HashMap<String, Object> hashMap = new HashMap<>();
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            String bizOrgCode = personIdentity.getBizOrgCode();
            if (StringUtils.isNotBlank(bizOrgCode)) {
                hashMap.put("bizOrgCode", bizOrgCode);
            }
            if (bizOrgCode == null) {
                return CommonResponseUtil.success(null);
            }
        }
        if (StringUtils.isNotBlank(systemCode)) {
            hashMap.put("systemCode", systemCode);
        } else {
            throw new BadRequest("系统编码不能为空");
        }
        return CommonResponseUtil.success(iFireFightingSystemService.getSystemStatusBySuper(hashMap));
    }


    @PersonIdentify
    @RequestMapping(value = "/fireAlarmLogPage", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "消防报警列表分页查询", produces = "application/json;charset=UTF-8", notes = "消防报警列表分页查询")
    public ResponseModel pageQuery(@RequestParam(required = false) String code,
                                   @RequestParam(required = false) String typeCode,
                                   @RequestParam(required = false) String bizOrgCode,
                                   CommonPageable commonPageable) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        ReginParams reginParams = getSelectedOrgInfo();
        List<CommonRequest> queryRequests = new ArrayList<>();
        CommonRequest request7 = new CommonRequest();
        request7.setName("system");
        request7.setValue(StringUtil.isNotEmpty(code) ? StringUtils.trimToNull(code) : null);
        queryRequests.add(request7);
        CommonRequest request8 = new CommonRequest();
        request8.setName("specificIndexKey");
        request8.setValue(StringUtil.isNotEmpty(typeCode) ? StringUtils.trimToNull(typeCode) : null);
        queryRequests.add(request8);
        CommonRequest request13 = new CommonRequest();
        request13.setName("bizOrgCode");
        request13.setValue(ObjectUtils.isEmpty(bizOrgCode) ? reginParams.getPersonIdentity().getBizOrgCode() : bizOrgCode);
        queryRequests.add(request13);
        CommonPageInfoParam param = CommonPageParamUtil.fillCommonPageInfoParam(queryRequests, commonPageable);
        return CommonResponseUtil.success(equipmentSpecificAlarmService.fireAlarmLogPage(param));
    }


    @PersonIdentify
    @RequestMapping(value = "/alarmTrend", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "报警类型趋势", produces = "application/json;charset=UTF-8", notes = "报警类型趋势")
    public ResponseModel alarmTrend(@RequestParam(required = false) String bizOrgCode) {
        if (StringUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        }
        return CommonResponseUtil.success(equipmentSpecificAlarmService.alarmTrend(bizOrgCode));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "概览稳压泵信息")
    @GetMapping("/getPressurePumpInfo")
    public ResponseModel getPressurePumpInfo(CommonPageable commonPageable, @RequestParam(required = false) String bizOrgCode) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        if (ObjectUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
            if (!ValidationUtil.isEmpty(personIdentity)) {
                bizOrgCode = personIdentity.getBizOrgCode();
                if (bizOrgCode == null) {
                    return CommonResponseUtil.success(null);
                }
            }
        }
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        Page<Map<String, Object>> pressurePumpInfo = fireFightingSystemMapper.getPressurePumpInfo(page, bizOrgCode, null);
        List<Long> ids = new ArrayList();
        pressurePumpInfo.getRecords().stream().map(item -> {
            item.put("monthStartNum", 0);
            item.put("halfHourStartNum", 0);
            item.put("twoHourStartNum", 0);
            item.put("fourHourStartNum", 0);
            item.put("update_time", "--");
            item.put("equipment_index_name", "--");
            String prefix = null;
            String suffix = null;
            String iotCode = item.get("iot_code").toString();
            if (iotCode.length() > 8) {
                prefix = iotCode.substring(0, 8);
                suffix = iotCode.substring(8);
            } else {
                throw new BadRequest("装备物联编码错误，请确认！");
            }

            String nowStrLong = DateUtils.getNowStrLong();
            Date mounthDate = null;
            try {
                mounthDate = DateUtils.getCurrentMonthStartTime(new Date());
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
            Date halfHour = DateUtils.dateAddMinutes(null, -30);
            Date twoHour = DateUtils.dateAddHours(null, -2);
            Date fourHour = DateUtils.dateAddHours(null, -4);
            Date oneHour = DateUtils.dateAddHours(null, -1);
            String startDateStr = DateUtils.convertDateToString(mounthDate, DateUtils.DATE_TIME_PATTERN);
            String half = DateUtils.convertDateToString(halfHour, DateUtils.DATE_TIME_PATTERN);
            String two = DateUtils.convertDateToString(twoHour, DateUtils.DATE_TIME_PATTERN);
            String four = DateUtils.convertDateToString(fourHour, DateUtils.DATE_TIME_PATTERN);
            String one = DateUtils.convertDateToString(oneHour, DateUtils.DATE_TIME_PATTERN);
            ResponseModel mounthEntity = null;
            ResponseModel halfHourEntity = null;
            ResponseModel twoHourEntity = null;
            ResponseModel fourHourEntity = null;
            ResponseModel oneHourEntity = null;
            try {
                mounthEntity = iotFeign.selectList(getAppKey(), getProduct(), getToken(), startDateStr, nowStrLong, prefix, suffix, pressurePumpStart);
                halfHourEntity = iotFeign.selectList(getAppKey(), getProduct(), getToken(), half, nowStrLong, prefix, suffix, pressurePumpStart);
                twoHourEntity = iotFeign.selectList(getAppKey(), getProduct(), getToken(), two, nowStrLong, prefix, suffix, pressurePumpStart);
                fourHourEntity = iotFeign.selectList(getAppKey(), getProduct(), getToken(), four, nowStrLong, prefix, suffix, pressurePumpStart);
                oneHourEntity = iotFeign.selectList(getAppKey(), getProduct(), getToken(), one, nowStrLong, prefix, suffix, pressurePumpStart);
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (200 == mounthEntity.getStatus()) {
                String json1 = JSON.toJSONString(mounthEntity.getResult());
                List<Map<String, String>> listObject1 = (List<Map<String, String>>) JSONArray.parse(json1);
                List<Map<String, String>> collect = listObject1.stream().filter(t -> (t.containsKey(pressurePumpStart) && t.get(pressurePumpStart).equals("true"))).collect(Collectors.toList());
                int num = collect.size();
                item.put("monthStartNum", num);
            }
            if (200 == halfHourEntity.getStatus()) {
                String json1 = JSON.toJSONString(halfHourEntity.getResult());
                List<Map<String, String>> listObject1 = (List<Map<String, String>>) JSONArray.parse(json1);
                List<Map<String, String>> collect = listObject1.stream().filter(t -> (t.containsKey(pressurePumpStart) && t.get(pressurePumpStart).equals("true"))).collect(Collectors.toList());
                int num = collect.size();
                item.put("halfHourStartNum", num);
            }
            if (200 == twoHourEntity.getStatus()) {
                String json1 = JSON.toJSONString(twoHourEntity.getResult());
                List<Map<String, String>> listObject1 = (List<Map<String, String>>) JSONArray.parse(json1);
                List<Map<String, String>> collect = listObject1.stream().filter(t -> (t.containsKey(pressurePumpStart) && t.get(pressurePumpStart).equals("true"))).collect(Collectors.toList());
                int num = collect.size();
                item.put("twoHourStartNum", num);
            }
            if (200 == fourHourEntity.getStatus()) {
                String json1 = JSON.toJSONString(fourHourEntity.getResult());
                List<Map<String, String>> listObject1 = (List<Map<String, String>>) JSONArray.parse(json1);
                List<Map<String, String>> collect = listObject1.stream().filter(t -> (t.containsKey(pressurePumpStart) && t.get(pressurePumpStart).equals("true"))).collect(Collectors.toList());
                int num = collect.size();
                item.put("fourHourStartNum", num);
            }
            if (200 == oneHourEntity.getStatus()) {
                String json1 = JSON.toJSONString(oneHourEntity.getResult());
                List<Map<String, String>> listObject1 = (List<Map<String, String>>) JSONArray.parse(json1);
                List<Map<String, String>> collect = listObject1.stream().filter(t -> (t.containsKey(pressurePumpStart) && t.get(pressurePumpStart).equals("true"))).collect(Collectors.toList());
                int num = collect.size();
                item.put("oneHourStartNum", num);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            long nowDateTime = new Date().getTime();//当前时间戳
            Map<String, String> stateMap = fireFightingSystemMapper.queryPressureNowStateBySpecificId((Long) item.get("id"));
            ids.add((Long) item.get("id"));
            boolean time = true;
            if (!ObjectUtils.isEmpty(stateMap) && stateMap.containsKey("update_date") && stateMap.containsKey("equipment_index_name")) {
                item.put("update_time", String.valueOf(stateMap.get("update_date")).replaceAll("T", " "));
                if (!ObjectUtils.isEmpty(stateMap.get("value"))) {
                    item.put("equipment_index_name", stateMap.get("equipment_index_name"));
                } else {
                    item.put("equipment_index_name", "无信号");
                }
                if ("启动".equals(item.get("equipment_index_name"))) {
                    long update_time = 0L;
                    try {
                        update_time = sdf.parse(String.valueOf(stateMap.get("update_date")).replaceAll("T", " ")).getTime();
                    } catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                    long res = nowDateTime - update_time;
                    long diffMinute = res / 1000 / 60;
                    if (diffMinute > 5) {
                        time = false;
                    }
                    item.put("upTime", diffMinute);
                }
            }
            item.put("stateDesc", Integer.parseInt(String.valueOf(item.get("isAlarm"))) == 0 && time ? "正常" : "异常");
            return item;
        }).collect(Collectors.toList());
        List<Map<String, Object>> stateMap = fireFightingSystemMapper.queryStartAndStopBySpecificId(ids);
        long diffMinute = 0L;
        if (!ObjectUtils.isEmpty(stateMap)) {
            String startTime = stateMap.get(0).get("update_date").toString();
            String endTime = stateMap.get(1).get("update_date").toString();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            long start = 0L;
            long end = 0L;
            try {
                start = sdf.parse(startTime.replaceAll("T", " ")).getTime();
                end = sdf.parse(endTime.replaceAll("T", " ")).getTime();
            } catch (ParseException e) {
                throw new RuntimeException(e);
            }
            long res = Math.abs(start - end);
            diffMinute = res / 1000 / 60;
        }
        long finalDiffMinute = diffMinute;
        pressurePumpInfo.getRecords().stream(
        ).map(item -> {
            item.put("startAndStopInterval", finalDiffMinute);
            if (finalDiffMinute > 5) {
                item.put("generalState", "异常");
            } else {
                item.put("generalState", "正常");
            }
            item.put("nameKey", pressurePumpStart);
            return item;
        }).collect(Collectors.toList());
        return CommonResponseUtil.success(pressurePumpInfo);
    }

    @PersonIdentify
    @RequestMapping(value = "/replaceVideo", method = RequestMethod.POST)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "替换视频", produces = "application/json;charset=UTF-8", notes = "替换视频")
    public ResponseModel replaceVideo(@RequestBody Map<String, String> ids) {
        String bizOrgCode = null;
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            bizOrgCode = personIdentity.getBizOrgCode();
            if (bizOrgCode == null) {
                return CommonResponseUtil.success(null);
            }
        }
        return CommonResponseUtil.success(supervisionVideoService.replaceVideo(ids, bizOrgCode));
    }

    @PersonIdentify
    @RequestMapping(value = "/queryVideoList", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询视频列表", produces = "application/json;charset=UTF-8", notes = "查询视频列表")
    public ResponseModel queryVideoList() {
        String bizOrgCode = null;
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            if (personIdentity.getCompanyBizOrgCode() == null) {
                bizOrgCode = personIdentity.getBizOrgCode();
            } else {
                bizOrgCode = personIdentity.getCompanyBizOrgCode();
            }
            if (bizOrgCode == null) {
                return CommonResponseUtil.success(null);
            }
        }
        return CommonResponseUtil.success(supervisionVideoService.queryVideoList(bizOrgCode));
    }

    @PersonIdentify
    @RequestMapping(value = "/queryVideoAllId", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询对应站下所有视频id", produces = "application/json;charset=UTF-8", notes = "根据id查询视频")
    public ResponseModel queryVideoAllId() {
        String bizOrgCode = null;
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            bizOrgCode = personIdentity.getBizOrgCode();
            if (bizOrgCode == null) {
                return CommonResponseUtil.success(null);
            }
        }
        return CommonResponseUtil.success(supervisionVideoService.queryVideoAllId(bizOrgCode));
    }

    @PersonIdentify
    @RequestMapping(value = "/selectPressureMonth", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "统计当月稳压泵启停", produces = "application/json;charset=UTF-8", notes = "统计当月稳压泵启停")
    public ResponseModel selectPressureMonth(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String startDay = df.format(new Date());
        Calendar calendar = Calendar.getInstance();
        calendar.set(Integer.parseInt(startDay.substring(0, 4)), Integer.parseInt(startDay.substring(5, 7)) - 1, 1);
        String firstDayOfMonth = new SimpleDateFormat("yyyy-MM-dd ").format(calendar.getTime());
        System.out.println("第一天：" + firstDayOfMonth + "00:00:00");
        //这里先设置要获取月份的下月的第一天
        calendar.set(Integer.parseInt(startDay.substring(0, 4)), Integer.parseInt(startDay.substring(5, 7)), 1);
        //这里将日期值减去一天，从而获取到要求的月份最后一天
        calendar.add(Calendar.DATE, -1);
        String lastDayOfMonth = new SimpleDateFormat("yyyy-MM-dd ").format(calendar.getTime());
        System.out.println("最后一天：" + lastDayOfMonth + "23:59:59");
        if (ObjectUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
            if (!ValidationUtil.isEmpty(personIdentity)) {
                bizOrgCode = personIdentity.getBizOrgCode();
                if (bizOrgCode == null) {
                    return CommonResponseUtil.success(null);
                }
            }
        }
        // 稳压泵信息
        List<Map<String, Object>> pressurePumps = fireFightingSystemMapper.selectAllPressurePumpInfo(bizOrgCode);
        ArrayList<Map<String, Object>> names = new ArrayList<>();
        // x轴数据
        List<Map<String, Object>> data = fireFightingSystemMapper.selectAllDays();
        for (Map<String, Object> pressurePump : pressurePumps) {
            HashMap<String, Object> bar = new HashMap<>();
            bar.put("name", pressurePump.get("name"));
            bar.put("id", pressurePump.get("id"));
            names.add(bar);
            String prefix = null;
            String suffix = null;
            String iotCode = pressurePump.get("iot_code").toString();
            if (iotCode.length() > 8) {
                prefix = iotCode.substring(0, 8);
                suffix = iotCode.substring(8);
            } else {
                throw new BadRequest("装备物联编码错误，请确认！");
            }
            ResponseModel mounthEntity = null;
            try {
                mounthEntity = iotFeign.selectList(getAppKey(), getProduct(), getToken(), firstDayOfMonth + "00:00:00", lastDayOfMonth + "23:59:59", prefix, suffix, null);
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (!ObjectUtils.isEmpty(mounthEntity) && "200".equals(String.valueOf(mounthEntity.getStatus()))) {
                for (Map<String, Object> item : data) {
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("name", pressurePump.get("name"));
                    String json1 = JSON.toJSONString(mounthEntity.getResult());
                    List<Map<String, String>> list = (List<Map<String, String>>) JSONArray.parse(json1);
                    List<Map<String, String>> collect = list.stream().filter(t -> (t.containsKey("time") && t.get("time").substring(0, 10).equals(item.get("date")))).collect(Collectors.toList());
                    map.put("value", collect.size());
                    map.put("id", pressurePump.get("id"));
                    if (item.containsKey("yData")) {
                        List<Map<String, Object>> yData1 = (List<Map<String, Object>>) item.get("yData");
                        yData1.add(map);
                    } else {
                        ArrayList<Map<String, Object>> maps = new ArrayList<>();
                        maps.add(map);
                        item.put("yData", maps);
                    }
                }
            }
        }
        HashMap<String, Object> result = new HashMap<>();
        result.put("names", names);
        result.put("data", data);
        return CommonResponseUtil.success(result);
    }

    @PersonIdentify
    @RequestMapping(value = "/selectPressureDetails", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "稳压泵详情", produces = "application/json;charset=UTF-8", notes = "稳压泵详情")
    public ResponseModel selectPressureDetails(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode) {
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            bizOrgCode = personIdentity.getBizOrgCode();
            if (bizOrgCode == null) {
                return CommonResponseUtil.success(null);
            }
        }
        List<Map<String, Object>> pressurePumps = fireFightingSystemMapper.selectPressureDetails(bizOrgCode);
        return CommonResponseUtil.success(pressurePumps);
    }


    @PersonIdentify
    @RequestMapping(value = "/selectPipePressureDetail", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "管网压力详情", produces = "application/json;charset=UTF-8", notes = "管网压力详情")
    public ResponseModel selectPipePressureDetail(@RequestParam(value = "equipmentSpecificId") String equipmentSpecificId) {
        Map<String, Object> map = fireFightingSystemMapper.selectEquipmentSpecificById(equipmentSpecificId);
        if (ObjectUtils.isEmpty(map) || ObjectUtils.isEmpty(map.get("iot_code"))) {
            return CommonResponseUtil.success(null);
        }
        String iotCode = map.get("iot_code").toString();
        String prefix = null;
        String suffix = null;
        if (iotCode.length() > 8) {
            prefix = iotCode.substring(0, 8);
            suffix = iotCode.substring(8);
        } else {
            throw new BadRequest("装备物联编码错误，请确认！");
        }

        String now = LocalDateTimeUtils.getNow();
        ResponseModel mounthEntity = null;
        try {
            mounthEntity = iotFeign.selectList(getAppKey(), getProduct(), getToken(), now.substring(0, 10) + " 00:00:00", now.substring(0, 10) + " 23:59:59", prefix, suffix, "FHS_PipePressureDetector_PipePressure");
        } catch (Exception e) {
            e.printStackTrace();
        }
        List<Map<String, String>> result = new ArrayList<>();
        if (200 == mounthEntity.getStatus()) {
            String json1 = JSON.toJSONString(mounthEntity.getResult());
            List<Map<String, String>> list = (List<Map<String, String>>) JSONArray.parse(json1);
            Collections.reverse(list);
            if (!CollectionUtils.isEmpty(list) && list.size() > 30) {
                for (int i = 0; i <= 29; i++) {
                    result.add(list.get(i));
                }
            } else {
                result.addAll(list);
            }

        }
        result.stream().map(item -> {
            if (!ObjectUtils.isEmpty(item.get("time"))) {
                item.put("time", change(String.valueOf(item.get("time"))));
            }
            return item;
        }).collect(Collectors.toList());

        return CommonResponseUtil.success(result);
    }

    private String change(String time) {
        //进行转化时区
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
        Date myDate = null;
        try {
            myDate = dateFormat.parse(time.replace("Z", "+0000"));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        //转换为年月日时分秒
        DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = df.format(myDate);
        return format;

    }
}
