package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.datasync.entity.FireEquipmentFireAlarm;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarm;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarmLog;
import com.yeejoin.equipmanage.common.entity.dto.AlarmDTO;
import com.yeejoin.equipmanage.common.entity.dto.EquipSpecificAlarmDTO;
import com.yeejoin.equipmanage.common.utils.CommonPageInfoParam;
import com.yeejoin.equipmanage.common.vo.AlarmDataVO;
import com.yeejoin.equipmanage.common.vo.AlarmEquipMockDataVO;
import com.yeejoin.equipmanage.common.vo.AlarmListDataVO;
import com.yeejoin.equipmanage.common.vo.TopographyAlarmVo;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * @author keyong
 * @title: IEquipmentSpecificAlarmService
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2020/11/2 15:13
 */
public interface IEquipmentSpecificAlarmService extends IService<EquipmentSpecificAlarm> {

    Page<Map<String, Object>> listPage(CommonPageInfoParam param);

    Page<Map<String, Object>> zlzxListPage(CommonPageInfoParam param);

    Page<Map<String, Object>> pageQuery(CommonPageInfoParam param);

    void handleExport(HttpServletResponse response, List<Long> ids, String alarmType);

    List<HashMap<String, Object>> getColumn(String alarmType);

    List<AlarmDataVO> getAlarmDetailById(Long id, String alarmType);

    AlarmEquipMockDataVO getEquipmentDetailById(Long id, String alarmType);

    Map<String, Object> detail(Long id);

    List<FireEquipmentFireAlarm> getFireEquipAlarmDetailsByAlarmId(List<Long> specificAlarmIds, List<Long> equipIndexIds);

    org.springframework.data.domain.Page<AlarmListDataVO> listAlarmsPage(CommonPageInfoParam param);


    org.springframework.data.domain.Page<TopographyAlarmVo> listAlarmsPageForTopography(CommonPageInfoParam param);

    Map<String, Object> getSpecificInfoById(Long id);

    Map<String, Object> getSpecificInfoByCode(String code);

    int getCountAlarmEquipment();

    int getCountEquipment();

    List<Map<String, Object>> getCountAlarm();

    Page<EquipSpecificAlarmDTO> getAlarmPage(Page page, AlarmDTO dto);

    Page<EquipSpecificAlarmDTO> getEqPage(Page page, AlarmDTO dto);

    List<EquipmentSpecificAlarmLog> getConfirmUser();


    //各种类型统计
    Integer getcountAlarmtype(String tyep);

    //统计已处理和未处理
    Integer getcountAlarmHandle(String tyep);

    /**
     * <pre>
     * 根据装备id和查询指定状态告警数据
     * </pre>
     *
     * @param status
     * @param equipmentSpecificId
     * @return
     */
    List<EquipmentSpecificAlarm> getEquipListBySpecific(Boolean status, Long equipmentSpecificId);

    LinkedList<Map<String, Object>> equipStatusCount(HashMap<String, Object> hashMap);

    Map<String, Object> equipAlarmLine(HashMap<java.lang.String,java.lang.Object> hashMap);

    List<Map<String, Object>> fireFacilitiesList(String bizOrgCode, String startTime, String endTime);
    Map<String, Object> dailyMaintenance(String bizOrgCode,String orgCode, String startTime, String endTime);
    Map<String, Object> inspectionMessage(String orgCode, String startTime, String endTime);

    Page<Map<String, Object>> fireAlarmLogPage(CommonPageInfoParam param);

    Page<Map<String, Object>> dcFireAlarmLogPage(CommonPageInfoParam param);

    List<Map<String, Object>> stationInfo();
    List<Map<String, Object>> alarmTrend(String bizOrgCode);

    List<Map<String, Object>> allList(CommonPageInfoParam param);

    int updateReadStatus(String messageId);
}
