package com.yeejoin.equipmanage.common.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 *
 *
 * @author wujiang
 * @date 2020-07-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_maintain")
@ApiModel(value = "Maintain对象", description = "")
public class Maintain extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "单据code")
	private String billCode;

	@ApiModelProperty(value = "保养时间")
	private Date maintainTime;

	@ApiModelProperty(value = "单据类型")
	private String billType;

	@ApiModelProperty(value = "保养人id")
	@TableField(value = "user_id", fill = FieldFill.INSERT)
	private Long userId;

	@ApiModelProperty(value = "公司名称")
	@TableField(value = "company_name", fill = FieldFill.INSERT)
	private String companyName;

	@ApiModelProperty(value = "公司code")
	@TableField(value = "org_code", fill = FieldFill.INSERT)
	private String orgCode;

	@ApiModelProperty(value = "部门名称")
	@TableField(value = "department_name", fill = FieldFill.INSERT)
	private String departmentName;

	@ApiModelProperty(value = "部门code")
	@TableField(value = "department_orgcode", fill = FieldFill.INSERT)
	private String departmentOrgcode;

	@ApiModelProperty(value = "创建人名")
	@TableField(value = "creator_name", fill = FieldFill.INSERT)
	private String creatorName;
}
