package com.yeejoin.amos.fas.dao.entity;

import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;


/**
 * <pre>
 * 基本实体类
 * </pre>
 *
 */

@MappedSuperclass

@EntityListeners(AuditingEntityListener.class) 
public class BasicEntity /*extends Resource*/ implements Serializable{

	private static final long serialVersionUID = -5464322936854328207L;
	
	/**
	 * id
	 */
	private long id;

	@CreatedDate
	@Column(name="create_date")
	private Date createDate = new Date();

	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	@Column(name = "ID",nullable=false,unique=true)
	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public Date getCreateDate() {
		return createDate;
	}

	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

}
