package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.EmergencyBizServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

@RestController
@RequestMapping(value = "/dp/biz/emergency")
@Api(tags = "大屏-应急-业务API")
public class EmergencyBizController {

    private EmergencyBizServiceImpl emergencyBizService;

    public EmergencyBizController (EmergencyBizServiceImpl emergencyBizService) {
        this.emergencyBizService = emergencyBizService;
    }

    /**
     * 应急大屏使用
     *
     * @param id 主键
     * @return Object
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/detail/{id}")
    @ApiOperation(httpMethod = "GET", value = "根据id获取应急事件详细信息", notes = "根据id获取应急事件详细信息")
    public ResponseModel<Object> getDetail(@PathVariable Long id) {
        return ResponseHelper.buildResponse(emergencyBizService.getDetail(id));
    }
}
