package com.yeejoin.amos.boot.module.statistcs.biz.utils;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.elevator.api.dto.FormValue;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

import static com.alibaba.fastjson.JSON.parseArray;


public class JsonUtils {
    //将json文件转化为Map<list<Map<>>>
    public static Map getResourceJson(Resource resource) {
        String json = null;
        try {
            json = IOUtils.toString(resource.getInputStream(), String.valueOf(StandardCharsets.UTF_8));
        } catch (IOException e) {
            throw new RuntimeException(resource + "json文件转化失败");
        }
        return JSONObject.parseObject(json, Map.class);
    }

    public static List<FormValue> getJsonData(Resource resource) {
        String json;
        try {
            json = IOUtils.toString(resource.getInputStream(), String.valueOf(StandardCharsets.UTF_8));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return parseArray(json, FormValue.class);
    }
}
