package com.yeejoin.amos.boot.module.hygf.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 勘察明细
 *
 * @author system_generator
 * @date 2023-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="SurveyDetailsDto", description="勘察明细")
public class SurveyDetailsDto  extends BaseDto {

   private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "勘察表id")
    private Long surveyInformationId;

    @ApiModelProperty(value = "勘察时间")
    private Date surveyorTime;

    @ApiModelProperty(value = "房屋类型")
    private String houseType;

    @ApiModelProperty(value = "房屋整体情况")
    private String houseSituation;

    @ApiModelProperty(value = "勘察人")
    private String surveyor;

    @ApiModelProperty(value = "房屋整体情况备注")
    private String houseSituationNotes;

    @ApiModelProperty(value = "房屋层数")
    private Integer houseLayers;

    @ApiModelProperty(value = "房屋总高")
    private Integer houseHeight;

    @ApiModelProperty(value = "房屋偏向")
    private Integer houseBias;

    @ApiModelProperty(value = "房屋偏向备注")
    private String houseBiasNotes;

    @ApiModelProperty(value = "房屋年限")
    private Integer houseLife;

    @ApiModelProperty(value = "地理位置-经度")
    private String locationLong;

    @ApiModelProperty(value = "地理位置-维度")
    private String locationLat;

    @ApiModelProperty(value = "地理位置-海拔")
    private String locationAlt;

    @ApiModelProperty(value = "屋顶通道")
    private String roofway;

    @ApiModelProperty(value = "屋顶通道备注")
    private String roofwayNotes;

    @ApiModelProperty(value = "周边障碍物")
    private String obstacle;

    @ApiModelProperty(value = "周边障碍物备注")
    private String obstacleNotes;

    @ApiModelProperty(value = "遮挡物")
    private String screen;

    @ApiModelProperty(value = "遮挡物备注")
    private String screenNotes;

    @ApiModelProperty(value = "解决措施")
    private String solutionMeasures;

    @ApiModelProperty(value = "房屋产权")
    private String houseProperty;

    @ApiModelProperty(value = "承重是否符合要求")
    private String houseBearing;

    @ApiModelProperty(value = "是否有明显裂痕")
    private String houseCrack;

    @ApiModelProperty(value = "屋顶可铺设面积")
    private String roofArea;

    @ApiModelProperty(value = "电表位置")
    private String meterPosition;

    @ApiModelProperty(value = "原电表位置")
    private String originalMeterPosition;

    @ApiModelProperty(value = "原电表位置备注")
    private String originalMeterPositionNotes;

    @ApiModelProperty(value = "原电表参数")
    private String originalMeterPositionParameter;

    @ApiModelProperty(value = "进户线")
    private String incomingLine;

    @ApiModelProperty(value = "进户线备注")
    private String incomingLineNotes;

    @ApiModelProperty(value = "逆变器位置预估")
    private String inverterPosition;

    @ApiModelProperty(value = "逆变器位置预估备注")
    private String inverterPositionNotes;

    @ApiModelProperty(value = "电表箱位置预估")
    private String meterBox;

    @ApiModelProperty(value = "电表箱位置预估备注")
    private String meterBoxNotes;

    @ApiModelProperty(value = "支架接地预估")
    private String support;

    @ApiModelProperty(value = "支架接地预估备注")
    private String supportNotes;

    @ApiModelProperty(value = "电表箱接地预估")
    private String grounding;

    @ApiModelProperty(value = "电表箱接地预估备注")
    private String groundingNotes;

    @ApiModelProperty(value = "关于邻居采光遮挡")
    private String daylightingObstruction;

    @ApiModelProperty(value = "房屋整体文件标识")
    private String overallHousingSurvey;

    @ApiModelProperty(value = "房屋周边文件标识")
    private String surroundingHouseSurvey;

    @ApiModelProperty(value = "房屋内部整体照片文件标识")
    private String insideHouseSurvey;

    @ApiModelProperty(value = "电表参数文件标识")
    private String electricitySurvey;

    @ApiModelProperty(value = "屋顶全貌文件标识")
    private String panoramaSurvey;

    @ApiModelProperty(value = "屋顶平面草图文件标识")
    private String planSketchSurvey;

    @ApiModelProperty(value = "房屋方位角文件标识")
    private String azimuthSurvey;

    @ApiModelProperty(value = "其他附件文件标识")
    private String otherAccessorySurvey;

}
