package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 经销商人员信息
 *
 * @author system_generator
 * @date 2023-07-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_unit_info")
public class UnitInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 企业名称
     */
	@TableField("name")
    private String name;

    /**
     * 注册地址
     */
	@TableField("register_address")
    private String registerAddress;

    /**
     * 工作地址
     */
	@TableField("work_address")
    private String workAddress;

    /**
     * 负责人名称
     */
	@TableField("head_name")
    private String headName;

    /**
     * 负责人电话
     */
	@TableField("head_phone")
    private String headPhone;

    /**
     * 负责人身份证号码
     */
	@TableField("head_id_number")
    private String headIdNumber;

    /**
     * 负责人身份证照片正面
     */
	@TableField("head_card_photo_front")
    private String headCardPhotoFront;

    /**
     * 负责人身份证照片反面
     */
	@TableField("head_card_photo_back")
    private String headCardPhotoBack;

    /**
     * 管理员账户名
     */
	@TableField("admin_login_name")
    private String adminLoginName;

    /**
     * 管理员电话
     */
	@TableField("admin_phone")
    private String adminPhone;

    /**
     * 管理员密码
     */
	@TableField("admin_login_pwd")
    private String adminLoginPwd;

    /**
     * 管理员平台用户id
     */
	@TableField("admin_user_id")
    private String adminUserId;

    /**
     * 平台公司id
     */
	@TableField("amos_company_seq")
    private Long amosCompanySeq;

    /**
     * 上级单位id
     */
	@TableField("parent_unit_id")
    private Long parentUnitId;

    /**
     * 角色id
     */
	@TableField("role_id")
    private String roleId;

}
