<html>
<head>
    <META http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
    <style type="text/css">
        .b1 {
            white-space-collapsing: preserve;
        }

        .b2 {
            margin: 1.0in 1.25in 1.0in 1.25in;
        }

        .eb-joba-bill {
            text-align: center;
            hyphenate: auto;
            font-family: Calibri;
            font-size: 20pt;
        }

        .eb-joba-bill > div {
            padding: 9px;
            background: #f3f3f3;
            border: 1px solid black;
        }

        .eb-joba-bill-table {
            width: 100%;
            border-collapse: collapse;
            border-spacing: 0;
        }

        td {
            width: 4%;
            height: 40px;
            padding-left: 10px;
            font-size: 18px;
            color: #343434;
            background: white;
            border: 1px solid black;
        }

        .eb-joba-bill-td-label {
            text-align: center;
            background: #f3f3f3;
        }

        .eb-joba-bill-table {
            padding: 6px 5px;
        }

        .eb-joba-bill-table img {
            width: 140px;
            height: 140px;
        }

        .eb-joba-bill-table {
            font-size: 35px;
        }

        .eb-threehandcheck-bill-header {
            height: 2.5em;
            font-size: 35px;
            text-align: center;
            background: #f3f3f3;
        }

        .eb-joba-bill-table {
            padding: 0;
            font-size: 16px;
            line-height: 1.5;
            text-indent: 2em;
        }

        .eb-joba-bill-table > div {
            width: 1098px;
            max-height: 900px;
            overflow: auto;
        }

        .eb-joba-bill-table img {
            max-width: 100%;
        }

        .eb-joba-bill-td-center {
            text-align: center;
        }
    </style>
    <meta content="DELL" name="author"/>
</head>
<body class="b1 b2">
<#if taskRiskControl?exists>
    <div class="eb-joba-bill">
        <table class="eb-joba-bill-table eb-threehandcheck-bill">
            <tr>
                <td colSpan="25" class="eb-threehandcheck-bill-header">
                    风险作业管控记录
                </td>
            </tr>
            <tr>
                <td class="eb-joba-bill-td-label" colSpan="4">项目名称</td>
                <td colSpan="21">${taskRiskControl.projectName!''}</td>
            </tr>
            <tr>
                <td class="eb-joba-bill-td-label" colSpan="4">风险作业计划名称</td>
                <td colSpan="21">${taskRiskControl.name!''}</td>
            </tr>
            <tr>
                <td class="eb-joba-bill-td-label" colSpan="4">风险作业类型</td>
                <td colSpan="9">
                    <#if taskRiskControl.riskWork?exists>
                        ${taskRiskControl.riskWork.riskWork.name!''}
                    </#if>
                </td>
                <td class="eb-joba-bill-td-label" colSpan="4">风险等级</td>
                <td colSpan="8">
                    <#if taskRiskControl.riskWork?exists>
                        ${taskRiskControl.riskWork.riskWork.levelName!''}
                    </#if>
                </td>
            </tr>
            <tr>
                <td class="eb-joba-bill-td-label" colSpan="4">计划开始时间</td>
                <td colSpan="9">
                    <#if taskRiskControl.startTime??>${taskRiskControl.startTime?string("yyyy-MM-dd")!''}</#if>
                </td>
                <td class="eb-joba-bill-td-label" colSpan="4">计划结束时间</td>
                <td colSpan="8">
                    <#if taskRiskControl.endTime??>${taskRiskControl.endTime?string("yyyy-MM-dd")!''}</#if>
                </td>
            </tr>
            <tr>
                <td class="eb-joba-bill-td-label" colSpan="4">实际开始时间</td>
                <td colSpan="9">
                    <#if taskRiskControl.taskStartTime??>${taskRiskControl.taskStartTime?string("yyyy-MM-dd")!''}</#if>
                </td>
                <td class="eb-joba-bill-td-label" colSpan="4">实际结束时间</td>
                <td colSpan="8">
                    <#if taskRiskControl.taskEndTime??>${taskRiskControl.taskEndTime?string("yyyy-MM-dd")!''}</#if>
                </td>
            </tr>
            <tr>
                <td class="eb-joba-bill-td-label" colSpan="4">分包商</td>
                <td colSpan="9">${taskRiskControl.companyName!''}</td>
                <td class="eb-joba-bill-td-label" colSpan="4">分包商主管</td>
                <td colSpan="8">${taskRiskControl.companyPersonName!''}</td>
            </tr>
            <tr>
                <td class="eb-joba-bill-td-label" colSpan="4">负责安全员</td>
                <td colSpan="21">${taskRiskControl.secPersonName!''}</td>
            </tr>
            <tr>
                <td class="eb-joba-bill-td-label" colSpan="4">项目地址</td>
                <td colSpan="21">${taskRiskControl.projectAddress!''}</td>
            </tr>
            <tr>
                <td class="eb-joba-bill-td-label" colSpan="25">主要内容</td>
            </tr>
            <tr>
                <td class="eb-joba-bill-td-label" colSpan="4" rowSpan="${(taskRiskControl.preProPersonList?size)+1}">专业人员</td>
                <td class="eb-joba-bill-td-label" colSpan="4">姓名</td>
                <td class="eb-joba-bill-td-label" colSpan="4">工种</td>
                <td class="eb-joba-bill-td-label" colSpan="5">资质证书</td>
                <td class="eb-joba-bill-td-label" colSpan="4">考试推送</td>
                <td class="eb-joba-bill-td-label" colSpan="4">知识推送</td>
            </tr>
            <#if taskRiskControl.preProPersonList?exists>
                <#list taskRiskControl.preProPersonList as e>
                    <tr>
                        <td class="eb-joba-bill-td-center" colSpan="4">${e.personName!''}</td>
                        <td class="eb-joba-bill-td-center" colSpan="4">${e.postName!''}</td>
                        <td class="eb-joba-bill-td-center" colSpan="5">
                            <#if e.certificate?exists>
                                <#list e.certificate as item>
                                    ${item}
                                </#list>
                            </#if>
                        </td>
                        <td class="eb-joba-bill-td-center" colSpan="4">
                            <#if e.taskExamStatus?? && e.taskExamStatus==1>
                                合格
                                <#else>
                                -
                            </#if>
                        </td>
                        <td class="eb-joba-bill-td-center" colSpan="4">
                            <#if e.taskKnowledgeStatus?? && e.taskKnowledgeStatus==1>
                                已读
                            <#else>
                                -
                            </#if>
                        </td>
                    </tr>
                </#list>
            </#if>
            <tr>
                <td class="eb-joba-bill-td-label" colSpan="4" rowSpan="${(taskRiskControl.preAssistPersonList?size)+ 1}">辅助人员</td>
                <td class="eb-joba-bill-td-label" colSpan="4">姓名</td>
                <td class="eb-joba-bill-td-label" colSpan="4">工种</td>
                <td class="eb-joba-bill-td-label" colSpan="5">资质证书</td>
                <td class="eb-joba-bill-td-label" colSpan="4">考试推送</td>
                <td class="eb-joba-bill-td-label" colSpan="4">知识推送</td>
            </tr>
            <#if taskRiskControl.preAssistPersonList?exists>
                <#list taskRiskControl.preAssistPersonList as e>
                    <tr key=${e.personId}>
                        <td class="eb-joba-bill-td-center" colSpan="4">${e.personName}</td>
                        <td class="eb-joba-bill-td-center" colSpan="4">${e.postName}</td>
                        <td class="eb-joba-bill-td-center" colSpan="5">
                            <#if e.certificate?exists>
                                <#list e.certificate as item>
                                    ${item}
                                </#list>
                            </#if>
                        </td>
                        <td class="eb-joba-bill-td-center" colSpan="4">
                            <#if e.taskExamStatus?? && e.taskExamStatus==1>
                                合格
                            <#else>
                                -
                            </#if>
                        </td>
                        <td class="eb-joba-bill-td-center" colSpan="4">
                            <#if e.taskKnowledgeStatus?? && e.taskKnowledgeStatus==1>
                                已读
                            <#else>
                                -
                            </#if>
                        </td>
                    </tr>
                </#list>
            </#if>
            <#if checkLength?? && (checkLength>0) >
                <tr>
                    <td class="eb-joba-bill-td-label" colSpan="4" rowSpan="${checkLength}">检查内容</td>
                    <td class="eb-joba-bill-td-label" colSpan="21">
                        <#if taskRiskControl.measureResultList?exists>
                            ${taskRiskControl.riskWork.riskWork.name!''}
                            <#else>
                            ${taskRiskControl.hazardWorkList[0].name!''}
                        </#if>
                    </td>
                </tr>
                <#if taskRiskControl.measureResultList?exists>
                    <#list taskRiskControl.measureResultList as item>
                        <tr>
                            <td class="eb-joba-bill-td-label" colSpan="21">
                                ${item.name!''}
                            </td>
                        </tr>
                        <tr>
                            <td class="eb-joba-bill-td-center" colSpan="2">${item_index+1}</td>
                            <td colSpan="16">${item.name!''}</td>
                            <td class="eb-joba-bill-td-center" colSpan="3">${(item.isOk==1)?string('合格','不合格')}</td>
                        </tr>
                    </#list>
                </#if>
                <#if taskRiskControl.hazardWorkList?exists>
                    <#list taskRiskControl.hazardWorkList as e>
                        <tr>
                            <td class="eb-joba-bill-td-label" colSpan="21">
                                ${e.name!''}
                            </td>
                        </tr>
                        <#if e.hazardousWorkResultList?exists>
                            <#list e.hazardousWorkResultList as item>
                                <tr>
                                    <td class="eb-joba-bill-td-center" colSpan="2">${item_index+1}</td>
                                    <td colSpan="16">${item.inputItemName!''}</td>
                                    <td class="eb-joba-bill-td-center" colSpan="3">${(item.isOk==1)?string('合格','不合格')}</td>
                                </tr>
                            </#list>
                        </#if>
                    </#list>
                </#if>
            </#if>
            <tr>
                <td class="eb-joba-bill-td-label" colSpan="25">现场检查照片</td>
            </tr>
            <#if secImgs?exists>
                <#list secImgs as e>
                    <tr>
                       <#if e.type??>
                            <td class="eb-joba-bill-td-label" colSpan="4" rowspan="${secImgLength}">
                                安全员
                            </td>
                       </#if>
                        <#if e.name??>
                            <td class="eb-joba-bill-td-center" colSpan="6" rowSpan="${e.nameRowSpan}">
                                ${e.name!''}
                            </td>
                        </#if>
                        <td class="eb-joba-bill-td-label" colSpan="4">
                            ${e.date?string("yyyy-MM-dd HH:mm:ss")}
                        </td>
                        <td colSpan="11" class="eb-joba-bill-td-center">
                            <#if e.imgs?exists>
                                <#list e.imgs as item>
                                    <img height="90" width="160" src="${item.filePath}" />
                                </#list>
                            </#if>
                        </td>
                    </tr>
                </#list>
            </#if>
            <#if techImgs?exists>
                <#list techImgs as e>
                    <tr>
                        <#if e.type??>
                            <td class="eb-joba-bill-td-label" colSpan="4" rowSpan="${techImgLength}">
                                技术员
                            </td>
                        </#if>
                        <#if e.name??>
                            <td class="eb-joba-bill-td-center" colSpan="6" rowSpan="${e.nameRowSpan}">
                                ${e.name!''}
                            </td>
                        </#if>
                        <td class="eb-joba-bill-td-label" colSpan="4">
                            ${e.date?string("yyyy-MM-dd HH:mm:ss")}
                        </td>
                        <td colSpan="11" class="eb-joba-bill-td-center">
                            <#if e.imgs?exists>
                                <#list e.imgs as item>
                                    <img height="90" width="160" src="${item.filePath}" />
                                </#list>
                            </#if>
                        </td>
                    </tr>
                </#list>
            </#if>
            <tr>
                <#if taskRiskControl.userEvaList?exists>
                    <td class="eb-joba-bill-td-label" colSpan="4" rowSpan="${((taskRiskControl.userEvaList?size)+3)}">
                        风险作业评价
                    </td>
                    <#else>
                    <td class="eb-joba-bill-td-label" colSpan="4" rowSpan="2">
                        风险作业评价
                    </td>
                </#if>
                <#if taskRiskControl.userEvaList?exists>
                    <td class="eb-joba-bill-td-label" colSpan="4">姓名</td>
                    <td class="eb-joba-bill-td-label" colSpan="6">评分</td>
                    <td class="eb-joba-bill-td-label" colSpan="11">评价内容</td>
                    <#else>
                    <td class="eb-joba-bill-td-center" colSpan="6">分包商</td>
                    <td class="eb-joba-bill-td-label" colSpan="4" rowSpan="2">评分评价</td>
                    <td class="eb-joba-bill-td-center" colSpan="11">
                        <#if taskRiskControl.companyEvaList?exists>
                            ${taskRiskControl.companyEvaList[0].rate!0}星
                        </#if>
                    </td>
                </#if>
            </tr>
            <#if taskRiskControl.userEvaList?exists>
                <#list taskRiskControl.userEvaList as e>
                    <tr>
                    <td class="eb-joba-bill-td-center" colSpan="4">${e.personName!''}</td>
                    <td class="eb-joba-bill-td-center" colSpan="6">
                        #{e.rate!0}星
                    </td>
                    <td colSpan="11">${e.content!''}</td>
                    </tr>
                </#list>
            </#if>
            <tr>
                <td class="eb-joba-bill-td-center" colSpan="6">分包商</td>
                <td class="eb-joba-bill-td-label" colSpan="4" rowSpan="2">评分评价</td>
                <td class="eb-joba-bill-td-center" colSpan="11">
                    <#if taskRiskControl.userEvaList?exists>
                    ${taskRiskControl.companyEvaList[0].rate!0}星
                    <#else>
                        0星
                    </#if>
                </td>
            </tr>
            <#if taskRiskControl.companyEvaList?exists>
                <tr>
                    <td class="eb-joba-bill-td-center" colSpan="6">${taskRiskControl.companyEvaList[0].companyName!''}
                    </td>
                    <td class="eb-joba-bill-td-center" colSpan="11">${taskRiskControl.companyEvaList[0].content!''}
                    </td>
                </tr>
            </#if>
        </table>
    </div>
</#if>
</body>
</html>