package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.api.dto.JgMaintenanceContractDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgMaintenanceContract;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgMaintenanceContractServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * 维保合同备案
 *
 * @author system_generator
 * @date 2023-12-12
 */
@RestController
@Api(tags = "维保合同备案Api")
@RequestMapping(value = "/jg-maintenance-contract")
public class JgMaintenanceContractController extends BaseController {

    @Autowired
    JgMaintenanceContractServiceImpl jgMaintenanceContractServiceImpl;

    /**
     * 批量新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/batchSaveOrUpdate")
    @ApiOperation(httpMethod = "POST", value = "批量新增维保合同备案", notes = "批量新增维保合同备案")
    public ResponseModel<Object> save(@RequestBody JgMaintenanceContractDto model, List<Integer> equipmentLists) {
        ReginParams reginParams = getSelectedOrgInfo();
        return ResponseHelper.buildResponse(jgMaintenanceContractServiceImpl.batchSaveOrUpdate(model, equipmentLists, reginParams));
    }

    /**
     * 提交
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/submit")
    @ApiOperation(httpMethod = "POST", value = "维保合同提交", notes = "维保合同提交")
    public ResponseModel<Object> submit(@RequestBody JgMaintenanceContractDto model) {
        return ResponseHelper.buildResponse(jgMaintenanceContractServiceImpl.submit(model));
    }

    /**
     * 撤回
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/revocation")
    @ApiOperation(httpMethod = "POST", value = "维保合同撤回", notes = "维保合同撤回")
    public ResponseModel<Object> revocation(@RequestBody JgMaintenanceContractDto model) {
        return ResponseHelper.buildResponse(jgMaintenanceContractServiceImpl.revocation(model));
    }
    /**
     * 维保合同驳回
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/rejected")
    @ApiOperation(httpMethod = "POST", value = "维保合同驳回", notes = "维保合同驳回")
    public ResponseModel<Object> rejected(@RequestBody JgMaintenanceContractDto model) {
        return ResponseHelper.buildResponse(jgMaintenanceContractServiceImpl.rejected(model));
    }

    /**
     * 维保合同受理
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/accepted")
    @ApiOperation(httpMethod = "POST", value = "维保合同受理", notes = "维保合同受理")
    public ResponseModel<Object> accepted(@RequestBody JgMaintenanceContractDto model) {
        return ResponseHelper.buildResponse(jgMaintenanceContractServiceImpl.accepted(model));
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/update")
    @ApiOperation(httpMethod = "POST", value = "根据sequenceNbr更新维保合同备案", notes = "根据sequenceNbr更新维保合同备案")
    public ResponseModel<Object> updateBySequenceNbrJgMaintenanceContract(@RequestBody JgMaintenanceContractDto dto, @RequestParam("sequenceNbr") Long sequenceNbr) {
        dto.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(jgMaintenanceContractServiceImpl.updateBySequenceNbr(dto));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/delete")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除维保合同备案", notes = "根据sequenceNbr删除维保合同备案")
    public ResponseModel<Boolean> deleteBySequenceNbr(@RequestParam("sequenceNbr") Long sequenceNbr) {
        JgMaintenanceContractDto jgMaintenanceContractDto = new JgMaintenanceContractDto();
        jgMaintenanceContractDto.setSequenceNbr(sequenceNbr);
        jgMaintenanceContractDto.setIsDelete(true);
        return ResponseHelper.buildResponse(jgMaintenanceContractServiceImpl.updateBySequenceNbr(jgMaintenanceContractDto));
    }

    /**
     * 根据sequenceNbr批量删除
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "根据sequenceNbr删除维保合同备案", notes = "根据sequenceNbr删除维保合同备案")
    @RequestMapping(value = "/batchDelete", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public ResponseModel<Boolean> deleteForBatch(Long[] ids) {
        return ResponseHelper.buildResponse(jgMaintenanceContractServiceImpl.deleteForBatch(ids));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/details")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个维保合同备案", notes = "根据sequenceNbr查询单个维保合同备案")
    public ResponseModel<JgMaintenanceContractDto> selectOne(@RequestParam("sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgMaintenanceContractServiceImpl.queryBySequenceNbr(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "维保合同备案分页查询", notes = "分页查询维保合同备案")
    public ResponseModel<Page<JgMaintenanceContractDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam(value = "size") int size, @RequestParam(value = "phase") int phase, JgMaintenanceContractDto maintenanceContractDto) {
        Page<JgMaintenanceContract> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        ReginParams reginParams = getSelectedOrgInfo();
        Page<JgMaintenanceContractDto> contractDtoPage = jgMaintenanceContractServiceImpl.queryForPage(page, phase, maintenanceContractDto, reginParams);
        return ResponseHelper.buildResponse(contractDtoPage);
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询维保合同备案", notes = "列表全部数据查询维保合同备案")
    @GetMapping(value = "/list")
    public ResponseModel<List<JgMaintenanceContractDto>> selectForList() {
        return ResponseHelper.buildResponse(jgMaintenanceContractServiceImpl.queryForJgMaintenanceContractList());
    }

}
