package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.common.StringUtil;
import com.yeejoin.amos.boot.module.jg.api.dto.JgMaintenanceContractDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgMaintenanceContract;
import com.yeejoin.amos.boot.module.jg.api.entity.JgRelationEquip;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.MaintenanceEnum;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgMaintenanceContractMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgMaintenanceContractService;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-12-12
 */
@Service
public class JgMaintenanceContractServiceImpl extends BaseService<JgMaintenanceContractDto, JgMaintenanceContract, JgMaintenanceContractMapper> implements IJgMaintenanceContractService {

    private static final String HANDLING_STATUS_DICTIONARY = "JGGZZZ";
    @Autowired
    RestHighLevelClient restHighLevelClient;
    @Autowired
    private JgMaintenanceContractMapper maintenanceContractMapper;
    @Autowired
    private JgRelationEquipServiceImpl jgRelationEquipServiceImpl;
    @Autowired
    private DataDictionaryServiceImpl iDataDictionaryService;

    /**
     * 监管-根据字典type,code获取字典值
     */
    private DataDictionary getDict(String dictType,String dictCode) {
        HashMap<String, String> dictMap = new HashMap<>();
        LambdaQueryWrapper<DataDictionary> queryWrapper = new LambdaQueryWrapper<DataDictionary>()
                .eq(DataDictionary::getType,dictType)
                .eq(DataDictionary::getCode, dictCode);
        return iDataDictionaryService.getOne(queryWrapper);
    }

    /**
     * 分页查询
     */
    public Page<JgMaintenanceContractDto> queryForPage(Page<JgMaintenanceContract> page, int phase, JgMaintenanceContractDto dto, ReginParams reginParams) {
        Page<JgMaintenanceContractDto> contractList = new Page<>();
        CompanyBo company = reginParams.getCompany();
        if (MaintenanceEnum.SHIYONG.getCode().equals(phase)) {
            //使用单位用"使用单位统一信用代码"匹配数据
            dto.setUseUnitCode(company.getCompanyOrgCode().toString());
            dto.setApplyFlow(MaintenanceEnum.SHIYONG.getMsg());
            contractList = maintenanceContractMapper.getContractList(page, dto);
        } else if (MaintenanceEnum.WEIBAO.getCode().equals(phase)) {
            //维保单位用"维保单位统一信用代码"匹配数据
            dto.setMaintenanceUnitCode(company.getCompanyCode());
            dto.setApplyFlow(MaintenanceEnum.WEIBAO.getMsg());
            contractList = maintenanceContractMapper.getContractList(page, dto);
        } else if (MaintenanceEnum.JIANGUAN.getCode().equals(phase)) {
            //监管单位用"接收机构统一使用代码"匹配
            dto.setReceiveOrgCode(company.getOrgCode());
            dto.setApplyFlow(MaintenanceEnum.JIANGUAN.getMsg());
            contractList = maintenanceContractMapper.getContractList(page, dto);
        }
        return contractList;
    }

    /**
     * 根据sequenceNbr查询数据
     */
    public JgMaintenanceContractDto queryBySequenceNbr(Long sequenceNbr) {
        return maintenanceContractMapper.queryBySequenceNbr(sequenceNbr);
    }

    /**
     * 根据sequenceNbr更新数据
     *
     * @param dto
     * @return
     */
    public Boolean updateBySequenceNbr(JgMaintenanceContractDto dto) {
        return maintenanceContractMapper.updateBySequenceNbr(dto);
    }

    /**
     * 批量删除
     */
    public Boolean deleteForBatch(Long[] ids) {
        return maintenanceContractMapper.deleteForBatch(Arrays.asList(ids));
    }

    /**
     * 维保合同提交
     */
    @Transactional
    public Boolean submit(JgMaintenanceContractDto dto){
        String[] split = dto.getApplyFlow().split("-");
        String lastFlowName = split[split.length - 1];
        String applyFlow = dto.getApplyFlow() + "-" + MaintenanceEnum.getMsgByCode(MaintenanceEnum.valueOf(lastFlowName).getCode()+1);
        dto.setApplyFlow(applyFlow);
        dto.setApplyStatus(FlowStatusEnum.TO_BE_PROCESSED.getName());
        return this.updateBySequenceNbr(dto);
    }
    /**
     * 维保合同撤回
     */
    @Transactional
    public Boolean revocation(JgMaintenanceContractDto dto){
        dto.setApplyStatus(FlowStatusEnum.TO_BE_SUBMITTED.getName());
        return this.updateBySequenceNbr(dto);
    }

    /**
     * 维保合同驳回
     */
    @Transactional
    public Boolean rejected(JgMaintenanceContractDto dto){
        String[] split = dto.getApplyFlow().split("-");
        String lastFlowName = split[split.length - 1];
        String applyFlow = dto.getApplyFlow() + "-" + MaintenanceEnum.getMsgByCode(MaintenanceEnum.valueOf(lastFlowName).getCode() - 1);
        dto.setApplyFlow(applyFlow);
        dto.setApplyStatus(FlowStatusEnum.REJECTED.getName());
        return this.updateBySequenceNbr(dto);
    }

    /**
     * 维保合同受理
     */
    @Transactional
    public Boolean accepted(JgMaintenanceContractDto dto){
        String[] split = dto.getApplyFlow().split("-");
        String lastFlowName = split[split.length - 1];
        String applyFlow = dto.getApplyFlow() + "-" + MaintenanceEnum.getMsgByCode(MaintenanceEnum.valueOf(lastFlowName).getCode() + 1);
        dto.setApplyFlow(applyFlow);
        dto.setApplyStatus(FlowStatusEnum.TO_BE_PROCESSED.getName());
        return this.updateBySequenceNbr(dto);
    }

    /**
     * 根据设备批量插入
     */
    @Transactional
    public Boolean batchSaveOrUpdate(JgMaintenanceContractDto dto, List<Integer> lists, ReginParams reginParams) {
        List<Integer> collect = lists.stream().filter(Objects::nonNull).collect(Collectors.toList());
        CompanyBo company = reginParams.getCompany();
        JgMaintenanceContract contract = new JgMaintenanceContract();
        BeanUtils.copyProperties(dto, contract);
        if (StringUtil.isNotEmpty(contract.getApplyNo())){
            //更新操作
            LambdaQueryWrapper<JgRelationEquip> queryWrapper = new LambdaQueryWrapper<JgRelationEquip>()
                    .eq(JgRelationEquip::getBusinessId,contract.getApplyNo())
                    .eq(JgRelationEquip::getIsDelete, false);
            List<Long> list = jgRelationEquipServiceImpl.list(queryWrapper).stream().map(JgRelationEquip::getSequenceNbr).collect(Collectors.toList());
            jgRelationEquipServiceImpl.deleteBatchSeq(list);
        }else {
            //新增操作
            //维保备案编号
            //TODO
            contract.setApplyNo("维保备案编号");
            contract.setUseUnitCode(company.getCompanyCode());
            contract.setUseUnitName(company.getCompanyName());
            contract.setApplyFlow(MaintenanceEnum.SHIYONG.getMsg());
            contract.setApplyStatus(FlowStatusEnum.TO_BE_SUBMITTED.getName());
            contract.setEquNum(collect.size());
            this.save(contract);
        }
        collect.forEach(x -> {
            JgRelationEquip equip = new JgRelationEquip();
            equip.setBusinessId(contract.getApplyNo());
            equip.setEquipId(String.valueOf(x));
            equip.setBusinessType(BusinessTypeEnum.MAINTENANCE_RECORD.getName());
            jgRelationEquipServiceImpl.save(equip);
        });
        return true;
    }

    /**
     * 列表查询 示例
     */
    public List<JgMaintenanceContractDto> queryForJgMaintenanceContractList() {
        return this.queryForList("", false);
    }
}