package com.yeejoin.amos.api.openapi.face.service;

import com.yeejoin.amos.api.openapi.face.model.ProduceInfoModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.MidEquipProduceInfoMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.MidEquipProduceInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.Date;
import java.util.List;

/**
 * 特种设备基本信息-制造信息 服务类
 *
 * @author duanwei
 * @date 2022-07-19
 */
@Component
public class ProduceInfoService extends AppBaseService<ProduceInfoModel, MidEquipProduceInfo, MidEquipProduceInfoMapper> {

    @Autowired
    private JgFileService fileService;

    /**
     *
     * 新增制造信息
     *
     * @param model 制造信息model列表
     * @return  成功返回“ok”
     */
    public String saveProduceInfo(List<ProduceInfoModel> model) {

        // TODO Auto-generated method stub
        if (ValidationUtil.isEmpty(model)) {
            throw new BadRequest("制造信息为空.");
        }

//        List<JgFile> fileList = new ArrayList<>();
//        List<JgFile> produceStandardList,productCertificateList,iumInstructionsList,supervisionCertList,ceCertList;

        for (ProduceInfoModel models : model) {
//            checkModel(models);
            models.setRecDate(new Date());
            models.setAppId(getAppId());
            ProduceInfoModel produceInfoModel = this.createWithModel(models);

//            produceStandardList = JSONObject.parseArray(JSONObject.toJSONString(models.getProduceStandard()), JgFile.class);
//            productCertificateList = JSONObject.parseArray(JSONObject.toJSONString(models.getProductCertificate()), JgFile.class);
//            iumInstructionsList = JSONObject.parseArray(JSONObject.toJSONString(models.getIumInstructions()), JgFile.class);
//            supervisionCertList = JSONObject.parseArray(JSONObject.toJSONString(models.getSupervisionCert()), JgFile.class);
//            ceCertList = JSONObject.parseArray(JSONObject.toJSONString(models.getCeCert()), JgFile.class);
//
//            for (JgFile files : produceStandardList) {
//                JgFile file = new JgFile();
//                file.setSequenceCode(models.getSequenceCode());
//                file.setAppId(getAppId());
//                file.setObjectType(JgFileObjectEnum.PRODUCE_INFO.getObject());
//                file.setAttributeType(JgFileAttributeEnum.PRODUCE_STANDARD.getAttribute());
//                file.setSyncDate(models.getSyncDate());
//                file.setFileUrl(files.getFileUrl());
//                file.setFileName(files.getFileName());
//                file.setRecDate(new Date());
//                file.setSquNbr(produceInfoModel.getSequenceNbr());
//                fileList.add(file);
//            }
//
//            for (JgFile files : productCertificateList) {
//                JgFile file = new JgFile();
//                file.setSequenceCode(models.getSequenceCode());
//                file.setAppId(getAppId());
//                file.setObjectType(JgFileObjectEnum.PRODUCE_INFO.getObject());
//                file.setAttributeType(JgFileAttributeEnum.PRODUCT_CERTIFICATE.getAttribute());
//                file.setSyncDate(models.getSyncDate());
//                file.setFileUrl(files.getFileUrl());
//                file.setFileName(files.getFileName());
//                file.setRecDate(new Date());
//                file.setSquNbr(produceInfoModel.getSequenceNbr());
//                fileList.add(file);
//            }
//            for (JgFile files : iumInstructionsList) {
//                JgFile file = new JgFile();
//                file.setSequenceCode(models.getSequenceCode());
//                file.setAppId(getAppId());
//                file.setObjectType(JgFileObjectEnum.PRODUCE_INFO.getObject());
//                file.setAttributeType(JgFileAttributeEnum.IUM_INSTRUCTIONS.getAttribute());
//                file.setSyncDate(models.getSyncDate());
//                file.setFileUrl(files.getFileUrl());
//                file.setFileName(files.getFileName());
//                file.setRecDate(new Date());
//                file.setSquNbr(produceInfoModel.getSequenceNbr());
//                fileList.add(file);
//            }
//
//            for (JgFile files : supervisionCertList) {
//                JgFile file = new JgFile();
//                file.setSequenceCode(models.getSequenceCode());
//                file.setAppId(getAppId());
//                file.setObjectType(JgFileObjectEnum.PRODUCE_INFO.getObject());
//                file.setAttributeType(JgFileAttributeEnum.SUPERVISION_CERT.getAttribute());
//                file.setSyncDate(models.getSyncDate());
//                file.setFileUrl(files.getFileUrl());
//                file.setFileName(files.getFileName());
//                file.setRecDate(new Date());
//                file.setSquNbr(produceInfoModel.getSequenceNbr());
//                fileList.add(file);
//            }
//
//            for (JgFile files : ceCertList) {
//                JgFile file = new JgFile();
//                file.setSequenceCode(models.getSequenceCode());
//                file.setAppId(getAppId());
//                file.setObjectType(JgFileObjectEnum.PRODUCE_INFO.getObject());
//                file.setAttributeType(JgFileAttributeEnum.CE_CERT.getAttribute());
//                file.setSyncDate(models.getSyncDate());
//                file.setFileUrl(files.getFileUrl());
//                file.setFileName(files.getFileName());
//                file.setRecDate(new Date());
//                file.setSquNbr(produceInfoModel.getSequenceNbr());
//                fileList.add(file);
//            }
        }
//        fileService.saveBatch(fileList);
        return "OK";
    }


    /**
     * 信息校验
     *
     * @param models
     */
//    private static void checkModel(ProduceInfoModel models) {
//
//        if(ValidationUtil.isEmpty(models.getSequenceCode())) {
//            throw new BadRequest("设备唯一标识码不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSuperviseCode())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"监管系统唯一编码不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getProduceUnitCreditCode())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"制造单位统一社会信用代码不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getProduceUnitName())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"制造单位名称不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getFactoryNum())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"出厂编号不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getProduceDate())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"制造日期不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getInspectionId())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"监督检验ID不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getProductCertificate())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"产品质量合格证明附件不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getIumInstructions())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"安装及使用维护保养说明附件不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSupervisionCert())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"监督检验证书附件不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSyncDate())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"同步时间不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSyncState())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"同步状态不能为空！");
//        }
//    }
}
