package com.yeejoin.amos.boot.module.common.biz.controller;

import java.text.ParseException;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.common.api.dto.DutyPersonDto;
import com.yeejoin.amos.boot.module.common.api.service.IDutyPersonService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;


/**
 * 值班班次
 *
 * @author system_generator
 * @date 2021-07-06
 */
@RestController
@Api(tags = "值班人员接口Api")
@RequestMapping(value = "/common/duty-person")
public class DutyPersonController extends BaseController {

    @Autowired
    IDutyPersonService iDutyPersonService;

    /**
     * 值班列表视图--分页
     *
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page-list")
    @ApiOperation(httpMethod = "GET", value = "值班列表视图", notes = "值班列表视图")
    public ResponseModel<IPage<Map<String, Object>>> pageList(
            @ApiParam(value = "开始日期", required = true) @RequestParam String beginDate,
            @ApiParam(value = "结束日期", required = true) @RequestParam String endDate,
            @ApiParam(value = "当前页", required = true) @RequestParam(value = "current") int current,
            @ApiParam(value = "页面大小", required = true) @RequestParam(value = "size") int size) throws ParseException {
        return ResponseHelper.buildResponse(iDutyPersonService.pageList(current, size, beginDate, endDate));
    }

    /**
     * 值班列表视图--不分页
     *
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/list")
    @ApiOperation(httpMethod = "GET", value = "值班列表视图-不分页", notes = "值班列表视图-不分页")
    public ResponseModel list(@ApiParam(value = "开始日期", required = true) @RequestParam String beginDate,
                              @ApiParam(value = "结束日期", required = true) @RequestParam String endDate,
                             @RequestParam(required = false) Long teamId) throws ParseException {
        return ResponseHelper.buildResponse(iDutyPersonService.list(teamId,beginDate, endDate));
    }


    /**
     * 值班月视图
     *
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping("/duty-detail")
    @ApiOperation(httpMethod = "GET", value = "值班月视图", notes = "值班月视图")
    public ResponseModel<List<Map<String, Object>>> dutyDetail(
            @ApiParam(value = "开始日期", required = true) @RequestParam String beginDate,
            @ApiParam(value = "结束日期", required = true) @RequestParam String endDate
    ) throws ParseException {
        return ResponseHelper.buildResponse(iDutyPersonService.statisticsDay(beginDate, endDate));
    }


    /**
     * 调班
     *
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping("/duty-adjust")
    @ApiOperation(httpMethod = "POST", value = "调班保存", notes = "调班保存")
    public ResponseModel dutyAdjust(@RequestBody DutyPersonDto dutyPersonDto) {
        return ResponseHelper.buildResponse(iDutyPersonService.save(dutyPersonDto));
    }


    /**
     * 调班
     *
     * @param instanceId    实例id
     * @param dutyPersonDto 业务对象
     * @return DutyCarDto
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping("/duty-adjust")
    @ApiOperation(httpMethod = "PUT", value = "调班更新", notes = "调班更新")
    public ResponseModel dutyAdjustUpdate(
            @RequestParam Long instanceId,
            @RequestBody DutyPersonDto dutyPersonDto) {
        return ResponseHelper.buildResponse(iDutyPersonService.update(instanceId, dutyPersonDto));
    }

    /**
     * 值班数据删除
     *
     * @param instanceId 实例id
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @return ResponseModel
     * @throws Exception 
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping("/{instanceId}/{startTime}/{endTime}")
    @ApiOperation(httpMethod = "DELETE", value = "值班数据删除", notes = "值班数据删除")
    public ResponseModel deleteDutyData(@PathVariable Long instanceId,@PathVariable String startTime,@PathVariable String endTime) throws Exception {
        if (ValidationUtil.isEmpty(instanceId)
                || ValidationUtil.isEmpty(startTime)
                || ValidationUtil.isEmpty(endTime)){
            throw new BadRequest("参数校验失败.");
        }
        // BUG 2807 删除逻辑缺陷，现在前端后端传入 删除月份 2021-09-10 by kongfm
        return ResponseHelper.buildResponse(iDutyPersonService.deleteDutyData(instanceId, startTime, endTime));
    }

    /**
     * 人员执勤导出
     *
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping("/exportExcel")
    @ApiOperation(httpMethod = "GET", value = "人员执勤导出", notes = "人员执勤导出")
    public ResponseModel exportExcel(HttpServletResponse response,
                                     @ApiParam(value = "开始日期", required = true) @RequestParam String beginDate,
                                     @ApiParam(value = "结束日期", required = true) @RequestParam String endDate) throws ParseException {
        return ResponseHelper.buildResponse(iDutyPersonService.downloadList(beginDate, endDate));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("查询指定日期值班人信息列表")
    @GetMapping("/person/{dutyDay}/list")
    public ResponseModel listDutyPerson(@ApiParam(value = "值班日期", required = true) @PathVariable String dutyDay,
                                        @ApiParam(value = "班次id") @RequestParam(required = false) Long shiftId,
                                        @ApiParam(value = "岗位") @RequestParam(required = false) String postType) {
        return ResponseHelper.buildResponse(iDutyPersonService.dayDutyPersonList(dutyDay, shiftId, postType));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("查询当前值班人信息列表")
    @GetMapping("/person/on_duty/list")
    public ResponseModel listOnDutyPerson() {
        return ResponseHelper.buildResponse(iDutyPersonService.listOnDutyPerson());
    }


    /**
     *
     * 新接口 根据值班区域id 查询值班人 by kongfm 2021-09-15
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/findByDutyAreaId/{dutyAreaId}")
    @ApiOperation(httpMethod = "GET", value = "根据值班区域ID查询当前值班人", notes = "根据值班区域ID查询当前值班人")
    public ResponseModel<List<DutyPersonDto>> findByDutyAreaId(
            @PathVariable Long dutyAreaId
            ) throws ParseException {
        return ResponseHelper.buildResponse(iDutyPersonService.findByDutyAreaId(dutyAreaId));
    }

}
