package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;

@Component
public class GetContactNameSchedulerJob {
	@Autowired
	RedisUtils redisUtils;

	@Autowired
	AlertCalledServiceImpl alertCalledServiceImpl;
	
	@Value("${redis.cache.failure.time}")
    private long time;
	/**
	 * 每天凌晨12:01执行方法，更新联系人在缓存中的数据
	 */
	@Scheduled(cron = "0 01 00 ? * *")
	public void excuteJob() {
			List<Map<String, String>> contactName = alertCalledServiceImpl.getContactName();
			redisUtils.set(RedisKey.CONTACT_USER, contactName, time);
	}
}
