package com.yeejoin.amos.boot.module.ccs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 消防视频表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("ast_fire_video")
public class FireVideo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 站点编码
     */
    @TableField("station_code")
    private String stationCode;

    /**
     * 站点名称
     */
    @TableField("station_name")
    private String stationName;

    /**
     * 唯一标识
     */
    @TableField("mrid")
    private String mrid;

    /**
     * 名称
     */
    @TableField("name")
    private String name;

    /**
     * 类型
     */
    @TableField("type")
    private String type;

    /**
     * 安装位置
     */
    @TableField("position")
    private String position;

    /**
     * 图片
     */
    @TableField("photo_url")
    private String photoUrl;

    /**
     * 所在建筑
     */
    @TableField("building_mrid")
    private String buildingMrid;

    /**
     * 所在建筑名称
     */
    @TableField("building_name")
    private String buildingName;

    /**
     * 视频播放地址
     */
    @TableField("play_url")
    private String playUrl;

    /**
     * 经度
     */
    @TableField("lng")
    private String lng;

    /**
     * 纬度
     */
    @TableField("lat")
    private String lat;

    /**
     * 关联的电力设备mrids
     */
    private String relationEquipmentMrids;
    
    /**
     * 关联的消防设备mrids
     */
    private String relationFireEquipmentMrids;
}
