package com.yeejoin.equipmanage.common.entity.dto;

import java.io.Serializable;
import java.util.Collection;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 
 * <pre>
 * 在岗监测视图
 * </pre>
 *
 * @author gwb
 * @version $Id: MonitorView.java, v 0.1 2021年9月10日 下午3:09:42 gwb Exp $
 */
@Data
@ApiModel(value = "在岗监测视频视图树", description = "")
public class MonitorViewTreeDto  implements Serializable
{
	
	/**
	 * <pre>
	 * MonitorViewPollingPeriod
	 * </pre>
	 */
	private static final long serialVersionUID = 710637336545868090L;

	@ApiModelProperty(value = "主键 ")
	private Long id;

	/**
	 * 节点名称
	 */
	@ApiModelProperty(value = "节点名称")
	private String treeName;

	/**
	 * 节点类型
	 */
	@ApiModelProperty(value = "节点类型")
	private String type;
	
	/**
	 * 子节点总数
	 */
	@ApiModelProperty(value = "子节点总数")
	private Integer total;

	/**
	 * 选中视频列表
	 */
	private Collection<MonitorViewTreeDto> children;
}
