package com.yeejoin.amos.latentdanger.dao.entity;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * @author keyong
 * @title: LatentDanger
 * <pre>
 * @description: 隐患表
 * </pre>
 * @date 2021/1/26 14:03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "p_latent_danger", autoResultMap = true)
@ApiModel(value="LatentDanger", description="隐患信息")
public class LatentDanger extends BasicEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 业务唯一标识
     */
    private String businessKey;

    /**
     * 公司组织机构
     */
    private String orgCode;

    /**
     * 隐患名称
     */
    private String dangerName;

    private String instanceId;

    private Long currentFlowRecordId;

    /**
     * 隐患等级（1：一般隐患；2：重大隐患；0：安全问题）
     */
    private String dangerLevel;

    /**
     * 隐患等级名称
     */
    private String dangerLevelName;

    /**
     * 隐患地点
     */
    private String dangerPosition;

    /**
     * 隐患类型（1：普通隐患；2：巡检隐患）
     */
    private String dangerType;

    /**
     * 隐患类型名称
     */
    private String dangerTypeName;

    /**
     * 备注
     */
    private String remark;

    /**
     * 整改类型（1：常规整改；2：安措计划；3：延期整改）
     */
    private String reformType;

    /**
     * 整改类型名称
     */
    private String reformTypeName;

    /**
     * 限制时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date reformLimitDate;

    private Integer overtimeState;

    @TableField(typeHandler = JacksonTypeHandler.class)
    private JSONObject reformJson;

    /**
     * 隐患状态（1：待评审；2：待治理；3：安措计划中；4：逾期未治理；5：待验证；6：治理完毕；7：已撤销）
     */
    private String dangerState;

    /**
     * 隐患状态名称
     */
    private String dangerStateName;

    /**
     * 发现人
     */
    private String discovererUserId;

    private String discovererDepartmentId;

    private String photoUrls;

    /**
     * 是否删除（0：否；1：是）
     */
    private Boolean deleted;

    /**
     * 记录修改时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateDate;

    /**
     * 延期治理时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date delayLimitDate;

    /**
     * 问题描述
     */
    private String problemDescription;

    /**
     * 原因分析
     */
    private String reasonAnalysis;

    /**
     * 举一反三
     */
    private String inferOtherThings;

    /**
     * 检查记录创建的隐患检查项对应id
     */
    private Long bizId;

    /**
     * 建筑id
     */
    private Long structureId;

    /**
     * 建筑名称
     */
    private String structureName;

    private String instanceKey;

    /**
     * 业务类型（不同业务创建的隐患以此区分:巡检隐患、防火监督隐患、其他隐患。。。）
     */
    private String bizType;

    @TableField(exist = false)
    private String bizTypeName;

    /**
     * 经度
     */
    private String longitude;

    /**
     * 纬度
     */
    private String latitude;

    /**
     * 业务信息
     */
    @TableField(typeHandler = JacksonTypeHandler.class)
    private JSONObject bizInfo;

    /**
     * 是否审核状态
     */
    @TableField(exist = false)
    private Boolean unReviewed;

    public Boolean getUnReviewed() {
        if ("dangerSubmit".equals(this.getDangerState())) {
            return true;
        }
        return false;
    }

    /**
     * 提交信息
     */
    @TableField(exist = false)
    private JSONObject flowJson;

    /**
     * 阶段状态
     */
    @TableField(exist = false)
    private String processState;

    /**
     * 阶段状态名称
     */
    @TableField(exist = false)
    private String processStateName;

    /**
     * 隐患创建人名称
     */
    @TableField(exist = false)
    private String checkUserName;

    /**
     * 复查执行人名称
     */
    @TableField(exist = false)
    private String executeUserName;
}
