package com.yeejoin.amos.supervision.business.util;



import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {

    private static Pattern NOT_ZERO_AT_THE_END = Pattern.compile("[1-9]+\\d*[1-9]+");

    private static Pattern numericPattern = Pattern.compile("-?[0-9]+\\.?[0-9]*");
    
    /**
     * 鍒ゆ柇瀵硅薄鏄惁涓虹┖
     *
     * @param str
     * @return
     */
    public static boolean isNotEmpty(Object str) {
        boolean flag = true;
        if (str != null && !str.equals("")) {
            if (str.toString().length() > 0) {
                flag = true;
            }
        } else {
            flag = false;
        }
        return flag;
    }

    /***************************************************************************
     * repeat - 閫氳繃婧愬瓧绗︿覆閲嶅鐢熸垚N娆＄粍鎴愭柊鐨勫瓧绗︿覆銆�
     *
     * @param src
     *            - 婧愬瓧绗︿覆 渚嬪: 绌烘牸(" "), 鏄熷彿("*"), "娴欐睙" 绛夌瓑...
     * @param num
     *            - 閲嶅鐢熸垚娆℃暟
     * @return 杩斿洖宸茬敓鎴愮殑閲嶅瀛楃涓�
     * @version 1.0 (2006.10.10) Wilson Lin
     **************************************************************************/
    public static String repeat(String src, int num) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < num; i++)
            s.append(src);
        return s.toString();
    }

    /**
     * 鍒ゆ柇鏄惁鏁板瓧琛ㄧず
     *
     * @param
     * @return 鏄惁鏁板瓧鐨勬爣蹇�
     */
    public static boolean isNumeric(String str) {
        // 璇ユ鍒欒〃杈惧紡鍙互鍖归厤鎵�鏈夌殑鏁板瓧 鍖呮嫭璐熸暟
        String bigStr;
        try {
            bigStr = new BigDecimal(str).toString();
        } catch (Exception e) {
            return false;//寮傚父 璇存槑鍖呭惈闈炴暟瀛椼��
        }

        Matcher isNum = numericPattern.matcher(bigStr); // matcher鏄叏鍖归厤
        if (!isNum.matches()) {
            return false;
        }
        return true;
    }


    public static int toInt(String s) {
        if (s != null && !"".equals(s.trim())) {
            try {
                return Integer.parseInt(s);
            } catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }


    /**
     * 鎴彇鍓嶅悗閮戒笉鏄�0鐨勬暟瀛楀瓧绗︿覆
     * <p>
     * 12010102 => 12010102
     * 12010100 => 120101
     * ab1201100b => 12011
     *
     * @param str
     * @return
     */
    public static String delEndZero(String str) {
        Matcher mat = NOT_ZERO_AT_THE_END.matcher(str);
        boolean rs = mat.find();
        if (rs) {
            return mat.group(0);
        }

        return null;
    }

    /**
     * <pre>
     * 绉婚櫎瀛楃涓插悗闈㈢殑0
     * </pre>
     *
     * @param s
     * @return
     */
    public static String removeSufixZero(String s) {
        if (s == null) {
            return "";
        }
        while (s.endsWith("0")) {
            if (s.equals("0")) {
                s = "";
                break;
            }
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String notNull(String s){
    	return s!=null?s:""; 
    }
    
    public static boolean isStartWithDigit(String str){
    	char firstCharacter = str.charAt(0);
    	return Character.isDigit(firstCharacter);
    }
    
    
    public static void main(String[] args){
    	System.out.println(isStartWithDigit("a3730e937-17e5-4720-8f69-99e8d87d2ee7"));
    }
}

