package com.yeejoin.amos.boot.module.tzs.flc.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.tzs.flc.biz.service.impl.InformProcessInfoServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.InformProcessInfoDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 通话记录附件
 *
 * @author system_generator
 * @date 2021-12-27
 */
@RestController
@Api(tags = "通话记录附件Api")
@RequestMapping(value = "/inform-process-info")
public class InformProcessInfoController extends BaseController {

    @Autowired
    InformProcessInfoServiceImpl informProcessInfoServiceImpl;

    /**
     * 新增通话记录附件
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增通话记录附件", notes = "新增通话记录附件")
	public ResponseModel<InformProcessInfoDto> save(@RequestBody InformProcessInfoDto model) {
	    model = informProcessInfoServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新通话记录附件", notes = "根据sequenceNbr更新通话记录附件")
	public ResponseModel<InformProcessInfoDto> updateBySequenceNbrInformProcessInfo(@RequestBody InformProcessInfoDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(informProcessInfoServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除通话记录附件", notes = "根据sequenceNbr删除通话记录附件")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(informProcessInfoServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个通话记录附件",  notes = "根据sequenceNbr查询单个通话记录附件")
	public ResponseModel<InformProcessInfoDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(informProcessInfoServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "通话记录附件分页查询",  notes = "通话记录附件分页查询")
	public ResponseModel<Page<InformProcessInfoDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<InformProcessInfoDto> page = new Page<InformProcessInfoDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(informProcessInfoServiceImpl.queryForInformProcessInfoPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "通话记录附件列表全部数据查询",   notes = "通话记录附件列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<InformProcessInfoDto>> selectForList() {
	    return ResponseHelper.buildResponse(informProcessInfoServiceImpl.queryForInformProcessInfoList());
	}
}
