package com.yeejoin.amos.boot.module.ccs.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 站端信息表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FireStationInfoDto", description = "站端信息表")
public class FireStationInfoDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "编号")
    private String code;

    @ApiModelProperty(value = "换流站类型")
    private String elecTypeName;

    @ApiModelProperty(value = "用途类型")
    private String useTypeName;

    @ApiModelProperty(value = "安全指数")
    private BigDecimal safetyIndex;

    @ApiModelProperty(value = "安全状态：1-重大风险、2-较大风险、3-一般风险、4-低风险")
    private Integer safetyStatus;

    @ApiModelProperty(value = "状态对应颜色")
    private String safetyStatusColor;

    @ApiModelProperty(value = "0-启用；1-停用")
    private Boolean status;

    @ApiModelProperty(value = "位置描述")
    private String position;

    @ApiModelProperty(value = "经度")
    private String lng;

    @ApiModelProperty(value = "纬度")
    private String lat;

    @ApiModelProperty(value = "换流站负责人")
    private String stationChargePerson;

    @ApiModelProperty(value = "负责人联系电话")
    private String chargePersonPhone;

    @ApiModelProperty(value = "安全负责人")
    private String safetyChargePerson;

    @ApiModelProperty(value = "安全负责人联系电话")
    private String safetyPersonPhone;

    @ApiModelProperty(value = "驻站消防队队长名称")
    private String fireCaptainPerson;

    @ApiModelProperty(value = "驻站消防队队长电话")
    private String fireCaptainPhone;
}
