package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireAlarmDayStatisticsDto;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireAlarmDayStatisticsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 换流站告警日统计
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "换流站告警日统计Api")
@RequestMapping(value = "/fire-alarm-day-statistics")
public class FireAlarmDayStatisticsController extends BaseController {

    @Autowired
    FireAlarmDayStatisticsServiceImpl fireAlarmDayStatisticsServiceImpl;

    /**
     * 新增换流站告警日统计
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增换流站告警日统计", notes = "新增换流站告警日统计")
    public ResponseModel<FireAlarmDayStatisticsDto> save(@RequestBody FireAlarmDayStatisticsDto model) {
        model = fireAlarmDayStatisticsServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新换流站告警日统计", notes = "根据sequenceNbr更新换流站告警日统计")
    public ResponseModel<FireAlarmDayStatisticsDto> updateBySequenceNbrFireAlarmDayStatistics(@RequestBody FireAlarmDayStatisticsDto model, @PathVariable(value = "sequenceNbr") String sequenceNbr) {
        model.setId(sequenceNbr);
        return ResponseHelper.buildResponse(fireAlarmDayStatisticsServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除换流站告警日统计", notes = "根据sequenceNbr删除换流站告警日统计")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(fireAlarmDayStatisticsServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个换流站告警日统计", notes = "根据sequenceNbr查询单个换流站告警日统计")
    public ResponseModel<FireAlarmDayStatisticsDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(fireAlarmDayStatisticsServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "换流站告警日统计分页查询", notes = "换流站告警日统计分页查询")
    public ResponseModel<Page<FireAlarmDayStatisticsDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {
        Page<FireAlarmDayStatisticsDto> page = new Page<FireAlarmDayStatisticsDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(fireAlarmDayStatisticsServiceImpl.queryForFireAlarmDayStatisticsPage(page));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "换流站告警日统计列表全部数据查询", notes = "换流站告警日统计列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<FireAlarmDayStatisticsDto>> selectForList() {
        return ResponseHelper.buildResponse(fireAlarmDayStatisticsServiceImpl.queryForFireAlarmDayStatisticsList());
    }
}
