package com.yeejoin.amos.boot.module.ccs.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireEquipmentAlarmLogServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireEquipmentAlarmLogDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 设备报警信息日志表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "设备报警信息日志表Api")
@RequestMapping(value = "/fire-equipment-alarm-log")
public class FireEquipmentAlarmLogController extends BaseController {

    @Autowired
    FireEquipmentAlarmLogServiceImpl fireEquipmentAlarmLogServiceImpl;

    /**
     * 新增设备报警信息日志表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增设备报警信息日志表", notes = "新增设备报警信息日志表")
	public ResponseModel<FireEquipmentAlarmLogDto> save(@RequestBody FireEquipmentAlarmLogDto model) {
	    model = fireEquipmentAlarmLogServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除设备报警信息日志表", notes = "根据sequenceNbr删除设备报警信息日志表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(fireEquipmentAlarmLogServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个设备报警信息日志表",  notes = "根据sequenceNbr查询单个设备报警信息日志表")
	public ResponseModel<FireEquipmentAlarmLogDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(fireEquipmentAlarmLogServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "设备报警信息日志表分页查询",  notes = "设备报警信息日志表分页查询")
	public ResponseModel<Page<FireEquipmentAlarmLogDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<FireEquipmentAlarmLogDto> page = new Page<FireEquipmentAlarmLogDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(fireEquipmentAlarmLogServiceImpl.queryForFireEquipmentAlarmLogPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "设备报警信息日志表列表全部数据查询",   notes = "设备报警信息日志表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<FireEquipmentAlarmLogDto>> selectForList() {
	    return ResponseHelper.buildResponse(fireEquipmentAlarmLogServiceImpl.queryForFireEquipmentAlarmLogList());
	}
}
