/*
Navicat MySQL Data Transfer

Source Server         : 172.16.10.85
Source Server Version : 80018
Source Host           : 172.16.10.85:3306
Source Database       : amos-ccs-biz

Target Server Type    : MYSQL
Target Server Version : 80018
File Encoding         : 65001

Date: 2021-11-09 18:01:08
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for asf_fire_alarm_day_statistics
-- ----------------------------
DROP TABLE IF EXISTS `asf_fire_alarm_day_statistics`;
CREATE TABLE `asf_fire_alarm_day_statistics` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `station_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '站点名称',
  `collect_date` date DEFAULT NULL COMMENT '统计日期',
  `equipment_definition_mrid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '装备定义mrid',
  `equipment_definition_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '装备定义名称',
  `alarm_times` int(11) DEFAULT '0' COMMENT '报警次数',
  `alarm_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '告警类型',
  `alarm_type_name` varchar(255) DEFAULT NULL COMMENT '告警类型名称',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='换流站告警日统计';

-- ----------------------------
-- Table structure for asf_fire_danger_day_statistics
-- ----------------------------
DROP TABLE IF EXISTS `asf_fire_danger_day_statistics`;
CREATE TABLE `asf_fire_danger_day_statistics` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `station_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '站点名称',
  `collect_date` date NOT NULL COMMENT '统计日期',
  `danger_times` int(11) DEFAULT '0' COMMENT '报警次数',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='换流站隐患日统计';

-- ----------------------------
-- Table structure for asf_fire_equipment_alarm
-- ----------------------------
DROP TABLE IF EXISTS `asf_fire_equipment_alarm`;
CREATE TABLE `asf_fire_equipment_alarm` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `station_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '站点名称',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `fire_equipment_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `fire_equipment_mrid` varchar(255) DEFAULT '0' COMMENT '消防设备id',
  `iot_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '设备编码',
  `fire_equipment_index_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '指标名称',
  `fire_equipment_index_key` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '指标编码',
  `fire_equipment_index_value` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '报警值',
  `frequency` int(11) NOT NULL DEFAULT '1' COMMENT '发生频次',
  `status` bit(1) NOT NULL DEFAULT b'1' COMMENT '报警状态：1报警0恢复',
  `type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '报警类型:alarm_type_fire（火灾报警）/alarm_type_trouble（故障告警）',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `recovery_date` datetime DEFAULT NULL COMMENT '告警恢复时间',
  `confirm_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '确认类型',
  `alam_reason` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '报警原因',
  `resolve_result` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '处理情况',
  `confirm_user` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '确警人员',
  `confirm_user_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '确警人员姓名',
  `confirm_date` datetime DEFAULT NULL COMMENT '确警时间',
  `system_mrids` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '装备所属消防系统code',
  `equipment_definition_mrid` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '装备定义code（冗余字段）',
  `equipment_definition_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '装备定义名称',
  `location` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '设备位置',
  `lng` varchar(20) DEFAULT NULL COMMENT '经度',
  `lat` varchar(20) DEFAULT NULL COMMENT '纬度',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`),
  KEY `idx_create_date` (`create_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC COMMENT='设备报警信息表';

-- ----------------------------
-- Table structure for asf_fire_equipment_alarm_log
-- ----------------------------
DROP TABLE IF EXISTS `asf_fire_equipment_alarm_log`;
CREATE TABLE `asf_fire_equipment_alarm_log` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `station_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点名称',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '站点编码',
  `fire_equipment_mrid` varchar(255) NOT NULL DEFAULT '0' COMMENT '消防设备id',
  `fire_equipment_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '设备名称',
  `fire_equipment_index_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '指标名称',
  `fire_equipment_index_key` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '指标编码',
  `fire_equipment_index_value` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '报警值',
  `fire_building_mrid` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '建筑id（冗余字段）',
  `type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '报警类型:alarm_type_fire（火灾报警）/alarm_type_trouble（故障告警）',
  `confirm_type` varchar(100) DEFAULT NULL COMMENT '确认类型',
  `confirm_type_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '确认类型名称',
  `alarm_reason` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '报警原因',
  `resolve_result` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '处理情况',
  `confirm_user_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '确警人员姓名',
  `confirm_date` datetime DEFAULT NULL COMMENT '确警时间',
  `system_mrids` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '装备所属消防系统code（冗余字段）',
  `equipment_definition_mrid` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '装备定义code（冗余字段）',
  `equipment_definition_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '装备定义名称',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '告警生成时间',
  `location` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '设备位置',
  `lng` varchar(20) DEFAULT NULL COMMENT '经度',
  `lat` varchar(20) DEFAULT NULL COMMENT '纬度',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`) USING BTREE,
  KEY `idx_create_date` (`create_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='设备报警信息日志表';

-- ----------------------------
-- Table structure for asf_fire_fmea_statistics
-- ----------------------------
DROP TABLE IF EXISTS `asf_fire_fmea_statistics`;
CREATE TABLE `asf_fire_fmea_statistics` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `station_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '站点名称',
  `evaluationOid` int(11) DEFAULT NULL COMMENT 'o值(0到10)',
  `evaluationSid` int(11) DEFAULT NULL COMMENT 's值(0到10)',
  `mutiby` int(11) DEFAULT NULL COMMENT 's*o值（冗余）',
  `risk_source_mrid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '风险mrid',
  `risk_source_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '风险名称',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='发生率/严重度矩阵统计表';

-- ----------------------------
-- Table structure for asf_fire_latent_danger
-- ----------------------------
DROP TABLE IF EXISTS `asf_fire_latent_danger`;
CREATE TABLE `asf_fire_latent_danger` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `station_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '站点名称',
  `danger_mrid` varchar(32) NOT NULL COMMENT '风险点id',
  `danger_name` varchar(255) DEFAULT NULL COMMENT '风险点名称',
  `danger_state_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '隐患状态:隐患状态（1：待评审；2：待治理；3：安措计划中；4：待验证；5：治理完毕；6：已撤销；7：延期治理中；8：延期治理待车间部门审核；9：延期治理待公司审核''',
  `danger_state_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '隐患状态名称',
  `danger_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '隐患类型枚举(1：无码无计划隐患；2：巡检隐患；3：有码无计划隐患；4：随手拍）',
  `danger_type_name` varchar(255) DEFAULT NULL COMMENT '隐患类型名称',
  `danger_level` varchar(20) DEFAULT NULL COMMENT '隐患等级（1：一般隐患；2：重大隐患） ',
  `discovery_date` datetime DEFAULT NULL COMMENT '隐患提交时间',
  `deal_state` tinyint(4) NOT NULL COMMENT '处理状态:1-未完成；2-已完成',
  `deal_date` datetime DEFAULT NULL COMMENT '治理日期',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `lng` varchar(20) DEFAULT NULL COMMENT '经度',
  `lat` varchar(20) DEFAULT NULL COMMENT '纬度',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='隐患信息';

-- ----------------------------
-- Table structure for asf_fire_risk_source
-- ----------------------------
DROP TABLE IF EXISTS `asf_fire_risk_source`;
CREATE TABLE `asf_fire_risk_source` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `station_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '站点编码',
  `station_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '站点名称',
  `mrid` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '唯一标识',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '装备名称',
  `parent_mrid` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '上级编号id',
  `risk_level_mrid` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '风险等级id',
  `risk_level_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '风险等级名称',
  `risk_level_color` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '风险等级颜色',
  `rpni` decimal(10,2) DEFAULT NULL COMMENT 'rpni属性',
  `rpn` decimal(10,2) DEFAULT NULL COMMENT '实时rpn',
  `status` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '状态(正常normal，异常anomaly)',
  `increment` decimal(10,2) DEFAULT NULL COMMENT 'rpn增量',
  `is_region` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC COMMENT='风险点表';

-- ----------------------------
-- Table structure for asf_fire_rpn_change_log
-- ----------------------------
DROP TABLE IF EXISTS `asf_fire_rpn_change_log`;
CREATE TABLE `asf_fire_rpn_change_log` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `station_name` varchar(255) DEFAULT NULL COMMENT '站点名称',
  `risk_point_mrid` varchar(255) DEFAULT NULL COMMENT '风险点id',
  `risk_point_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '风险点名称',
  `risk_point_status` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '点状态：normal-正常；anomaly-异常；',
  `level_code` varchar(255) DEFAULT NULL COMMENT '1-1级；2-2级；3-3级；4-4级',
  `level_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '等级名称 ',
  `level_change_type` tinyint(4) DEFAULT NULL COMMENT '安全等级变化类型:0-安全等级下降；1-安全等级不变；2-安全等级上升',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='风险点变化流水';

-- ----------------------------
-- Table structure for asf_fire_station_info
-- ----------------------------
DROP TABLE IF EXISTS `asf_fire_station_info`;
CREATE TABLE `asf_fire_station_info` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `code` varchar(32) NOT NULL COMMENT '编号',
  `elec_type_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '换流站类型',
  `use_type_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '用途类型',
  `safety_index` decimal(4,1) DEFAULT NULL COMMENT '安全指数',
  `safety_status` tinyint(4) DEFAULT NULL COMMENT '安全状态：1-重大风险、2-较大风险、3-一般风险、4-低风险',
  `safety_status_color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '状态对应颜色',
  `status` bit(1) NOT NULL DEFAULT b'0' COMMENT '0-启用；1-停用',
  `position` varchar(255) DEFAULT NULL COMMENT '位置描述',
  `lng` varchar(20) DEFAULT NULL COMMENT '经度',
  `lat` varchar(20) DEFAULT NULL COMMENT '纬度',
  `station_charge_person` varchar(50) DEFAULT NULL COMMENT '换流站负责人',
  `charge_person_phone` varchar(20) DEFAULT NULL COMMENT '负责人联系电话',
  `safety_charge_person` varchar(50) DEFAULT NULL COMMENT '安全负责人',
  `safety_person_phone` varchar(20) DEFAULT NULL COMMENT '安全负责人联系电话',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  `fire_captain_phone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '驻站消防队队长电话',
  `fire_captain_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '驻站消防队队长名称',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uniq_code` (`code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='站端信息表';

-- ----------------------------
-- Table structure for ast_fire_building
-- ----------------------------
DROP TABLE IF EXISTS `ast_fire_building`;
CREATE TABLE `ast_fire_building` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `station_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '站点名称',
  `mrid` varchar(255) DEFAULT NULL COMMENT '消防建筑唯一标识',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `classify` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '建筑类别',
  `floor_number` varchar(32) DEFAULT NULL COMMENT '楼层数量',
  `parent_mrid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '父级mrid',
  `type` varchar(20) DEFAULT NULL COMMENT '类型（建筑、楼层、房间）',
  `photo_url` text COMMENT '建筑图片',
  `lng` varchar(20) DEFAULT NULL COMMENT '经度',
  `lat` varchar(20) DEFAULT NULL COMMENT '纬度',
  `create_date` datetime DEFAULT NULL COMMENT '创建日期',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='消防建筑表';

-- ----------------------------
-- Table structure for ast_fire_equipment
-- ----------------------------
DROP TABLE IF EXISTS `ast_fire_equipment`;
CREATE TABLE `ast_fire_equipment` (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT 'id',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `station_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '站点名称',
  `mrid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '实物id',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '设备名称',
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '设备编码',
  `category_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '设备类别名称',
  `category_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '设备类别编码',
  `img` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '设备图片',
  `iot_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '设备物联编码',
  `work_area` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '所属区域',
  `build_mrid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '所在建筑id',
  `fighting_system_mrids` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '所属消防系统ids',
  `position` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '位置',
  `in_use_date` datetime DEFAULT NULL COMMENT '使用日期',
  `is_iot` bit(1) DEFAULT b'0' COMMENT '是否为物联设备：0-否；1-是',
  `status` varchar(255) DEFAULT NULL COMMENT '状态',
  `in_use_state` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '使用状态',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `build_name` varchar(255) DEFAULT NULL COMMENT '建筑名称',
  `area_mrid` varchar(255) DEFAULT NULL COMMENT '物理区域id',
  `lng` varchar(20) DEFAULT NULL COMMENT '经度',
  `lat` varchar(20) DEFAULT NULL COMMENT '纬度',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='消防设备资产';

-- ----------------------------
-- Table structure for ast_fire_equipment_info
-- ----------------------------
DROP TABLE IF EXISTS `ast_fire_equipment_info`;
CREATE TABLE `ast_fire_equipment_info` (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `fire_equipment_mrid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '消防资产id',
  `field_name` varchar(255) DEFAULT NULL COMMENT '字段名（英文）',
  `field_label` varchar(255) DEFAULT NULL COMMENT '中文名',
  `value` varchar(255) DEFAULT NULL COMMENT '属性值',
  `data_type` varchar(255) DEFAULT NULL COMMENT '数据类型',
  `measure_unit` varchar(255) DEFAULT NULL COMMENT '计量单位',
  `is_must` bit(1) DEFAULT NULL COMMENT '是否必填',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_fire_equipment_mrid` (`fire_equipment_mrid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='消防资产参数信息';

-- ----------------------------
-- Table structure for ast_fire_fighting_system
-- ----------------------------
DROP TABLE IF EXISTS `ast_fire_fighting_system`;
CREATE TABLE `ast_fire_fighting_system` (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT 'id',
  `station_name` varchar(255) DEFAULT NULL COMMENT '站点名称',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `mrid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '资产id',
  `install_date` varchar(255) DEFAULT NULL COMMENT '安装日期',
  `charge_person` varchar(255) DEFAULT NULL COMMENT '负责人',
  `charge_person_phone` varchar(255) DEFAULT NULL COMMENT '负责人电话',
  `construction_unit` varchar(255) DEFAULT NULL COMMENT '施工单位',
  `maintenance_unit` varchar(255) DEFAULT NULL COMMENT '维保单位',
  `first_maintenance_date` datetime DEFAULT NULL COMMENT '首次维保日期',
  `maintenance_frequency` varchar(255) DEFAULT NULL COMMENT '维保频率',
  `maintenance_phone` varchar(255) DEFAULT NULL COMMENT '维保电话',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  `lng` varchar(20) DEFAULT NULL COMMENT '经度',
  `lat` varchar(20) DEFAULT NULL COMMENT '纬度',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='消防系统信息';

-- ----------------------------
-- Table structure for ast_fire_vehicle
-- ----------------------------
DROP TABLE IF EXISTS `ast_fire_vehicle`;
CREATE TABLE `ast_fire_vehicle` (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT 'id',
  `mrid` varchar(255) DEFAULT NULL COMMENT '消防资产id',
  `station_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '站点名称',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `number` varchar(255) DEFAULT NULL COMMENT '车辆号',
  `type` varchar(255) DEFAULT NULL COMMENT '车辆类别名称',
  `standard` varchar(255) DEFAULT NULL COMMENT '规格型号',
  `manufacturer` varchar(255) DEFAULT NULL COMMENT '厂商',
  `brand` varchar(255) DEFAULT NULL COMMENT '品牌',
  `country` varchar(255) DEFAULT NULL COMMENT '国别',
  `chassis_country` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '底盘国别',
  `chassis_brand` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '底盘品牌',
  `iot_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '物联编码',
  `state` varchar(255) DEFAULT NULL COMMENT '车辆状态',
  `start_state` varchar(255) DEFAULT NULL COMMENT '启动状态',
  `last_start_date` datetime DEFAULT NULL COMMENT '最近启动时间',
  `maintenance_unit` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '维保单位',
  `firstmaintenance_date` timestamp NULL DEFAULT NULL COMMENT '首次维保日期',
  `maintenance_frequency` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '维保频率',
  `maintenance_phone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '维保电话',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `updatedate` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `lng` varchar(20) DEFAULT NULL COMMENT '经度',
  `lat` varchar(20) DEFAULT NULL COMMENT '纬度',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='消防车辆信息';

-- ----------------------------
-- Table structure for ast_fire_vehicle_info
-- ----------------------------
DROP TABLE IF EXISTS `ast_fire_vehicle_info`;
CREATE TABLE `ast_fire_vehicle_info` (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `fire_vehicle_mrid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '消防资产id',
  `field_name` varchar(255) DEFAULT NULL COMMENT '字段名（英文）',
  `field_label` varchar(255) DEFAULT NULL COMMENT '中文名',
  `value` varchar(255) DEFAULT NULL COMMENT '属性值',
  `data_type` varchar(255) DEFAULT NULL COMMENT '数据类型',
  `measure_unit` varchar(255) DEFAULT NULL COMMENT '计量单位',
  `is_must` bit(1) DEFAULT NULL COMMENT '是否必填',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_fire_vehicle_mrid` (`fire_vehicle_mrid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='消防资产参数信息';

-- ----------------------------
-- Table structure for ast_fire_video
-- ----------------------------
DROP TABLE IF EXISTS `ast_fire_video`;
CREATE TABLE `ast_fire_video` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `station_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '站点名称',
  `mrid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '唯一标识',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '类型',
  `position` varchar(255) DEFAULT NULL COMMENT '安装位置',
  `photo_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci COMMENT '图片',
  `building_mrid` varchar(255) DEFAULT NULL COMMENT '所在建筑',
  `building_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '所在建筑名称',
  `play_url` varchar(255) DEFAULT NULL COMMENT '视频播放地址',
  `lng` varchar(20) DEFAULT NULL COMMENT '经度',
  `lat` varchar(20) DEFAULT NULL COMMENT '纬度',
  `create_date` datetime DEFAULT NULL COMMENT '创建日期',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='消防视频表';

-- ----------------------------
-- Table structure for ast_fire_water
-- ----------------------------
DROP TABLE IF EXISTS `ast_fire_water`;
CREATE TABLE `ast_fire_water` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `station_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '站点名称',
  `mrid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '唯一标识',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `classify` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '水源类别',
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '水池类型（消防水池、消防栓、消防水鹤、天然水源）',
  `water_level` varchar(255) DEFAULT NULL COMMENT '水池液位',
  `contant_person` varchar(255) DEFAULT NULL COMMENT '联系人',
  `contant_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '联系电话',
  `photo_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci COMMENT '图片',
  `lng` varchar(20) DEFAULT NULL COMMENT '经度',
  `lat` varchar(20) DEFAULT NULL COMMENT '纬度',
  `create_date` datetime DEFAULT NULL COMMENT '创建日期',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='消防水源表';

-- ----------------------------
-- Table structure for DATABASECHANGELOG
-- ----------------------------
DROP TABLE IF EXISTS `DATABASECHANGELOG`;
CREATE TABLE `DATABASECHANGELOG` (
  `ID` varchar(255) NOT NULL,
  `AUTHOR` varchar(255) NOT NULL,
  `FILENAME` varchar(255) NOT NULL,
  `DATEEXECUTED` datetime NOT NULL,
  `ORDEREXECUTED` int(11) NOT NULL,
  `EXECTYPE` varchar(10) NOT NULL,
  `MD5SUM` varchar(35) DEFAULT NULL,
  `DESCRIPTION` varchar(255) DEFAULT NULL,
  `COMMENTS` varchar(255) DEFAULT NULL,
  `TAG` varchar(255) DEFAULT NULL,
  `LIQUIBASE` varchar(20) DEFAULT NULL,
  `CONTEXTS` varchar(255) DEFAULT NULL,
  `LABELS` varchar(255) DEFAULT NULL,
  `DEPLOYMENT_ID` varchar(10) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- ----------------------------
-- Table structure for DATABASECHANGELOGLOCK
-- ----------------------------
DROP TABLE IF EXISTS `DATABASECHANGELOGLOCK`;
CREATE TABLE `DATABASECHANGELOGLOCK` (
  `ID` int(11) NOT NULL,
  `LOCKED` bit(1) NOT NULL,
  `LOCKGRANTED` datetime DEFAULT NULL,
  `LOCKEDBY` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
SET FOREIGN_KEY_CHECKS=1;