package com.yeejoin.amos.boot.biz.common.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface ResultFieldMapping {
    /**
     * 需要转换的字段配置
     */
    ResultFieldMap[] value();

    @interface ResultFieldMap {
        // 源字段路径（支持嵌套）
        String sourceField();
        // 目标字段路径（支持嵌套）
        String targetField();
        // 查询服务类
        Class<?> serviceClass();
        // 查询方法名称
        String queryMethod();
        // 查询参数类型（默认String）
        Class<?> queryParamType() default String.class;
    }
}

