package com.yeejoin.amos.api.openapi.controller;

import com.yeejoin.amos.api.openapi.face.dto.EquipmentCategoryDto;
import com.yeejoin.amos.api.openapi.feign.TzsServiceFeignClient;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * 特种设备监管controller
 *
 * @author Administrator
 */
@RestController
@Api(tags = "设备定义Api")
@RequestMapping(value = "/equipment-category")
public class EquipmentCategoryController {

    @Autowired
    TzsServiceFeignClient tzsServiceFeignClient;

    /**
     * 设备定义列表数据查询
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/list")
    @ApiOperation(httpMethod = "GET", value = "设备定义列表数据查询", notes = "设备定义列表数据查询")
    public ResponseModel<List<EquipmentCategoryDto>> page() {
        return tzsServiceFeignClient.getEquipmentCategoryList();
    }

}
