package com.yeejoin.amos.boot.module.elevator.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 派遣单
 *
 * @author kongfm
 * @date 2021-08-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="DispatchPaperDto", description="派遣单")
public class DispatchPaperDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "警情id")
    private Long alertId;

    @ApiModelProperty(value = "组织code")
    private String orgCode;

    @ApiModelProperty(value = "完成状态")
    private String paperStatus;

    @ApiModelProperty(value = "完成状态code")
    private String paperStatusCode;

    @ApiModelProperty(value = "处置环节")
    private String processStatus;

    @ApiModelProperty(value = "处置环节code")
    private String processStatusCode;

    @ApiModelProperty(value = "警情类型")
    private String alertType;

    @ApiModelProperty(value = "警情类型code")
    private String alertCode;

    @ApiModelProperty(value = "派遣时间")
    private Date dispatchTime;

    @ApiModelProperty(value = "派遣人id")
    private String sendUserId;

    @ApiModelProperty(value = "派遣人名称")
    private String sendUserName;

    @ApiModelProperty(value = "使用单位id")
    private Long useOrgId;

    @ApiModelProperty(value = "维保单位id 困人救援时为三级响应单位id")
    private Long repairOrgId;

    @ApiModelProperty(value = "维保单位社会信用代码 ")
    private String repairOrgCreditCode;

    @ApiModelProperty(value = "使用单位任务id")
    private Long useOrgTaskId;

    @ApiModelProperty(value = "维保单位任务id/ 困人救援时为三级调派的任务id ")
    private Long repairOrgTaskId;

    @ApiModelProperty(value = "维修完成时间/维保处置完成时间")
    private Date feedbackFinishTime;

    @ApiModelProperty(value = "维修投诉反馈方式code")
    private String feedbackCode;

    @ApiModelProperty(value = "维修投诉反馈方式")
    private String feedbackType;

    @ApiModelProperty(value = "维修投诉回访时间")
    private Date feedbackTime;

    @ApiModelProperty(value = "维修投诉回访人id")
    private String feedbackUid;

    @ApiModelProperty(value = "维修投诉回访人名称")
    private String feedbackUname;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "到达时间")
    private Date arriveTime;

    @ApiModelProperty(value = "处置时间")
    private Date dealTime;

    @ApiModelProperty(value = "救援机构名称")
    private String saveOrgName;

    @ApiModelProperty(value = "维修单位名称")
    private String repairOrgName;

    @ApiModelProperty(value = "维修人")
    private String repairUser;

    @ApiModelProperty(value = "处置单位")
    private String dealOrgName;

    @ApiModelProperty(value = "处置人")
    private String dealUser;

    @ApiModelProperty(value = "到达反馈方式")
    private String arriveFeedbackType;

    @ApiModelProperty(value = "到达反馈方式code")
    private String arriveFeedbackCode;

    @ApiModelProperty(value = "救出时间-- 冗余字段便于查询")
    private Date saveTime;

}
