package com.yeejoin.amos.boot.module.elevator.flc.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.elevator.flc.api.entity.InformProcessInfo;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.elevator.flc.biz.service.impl.InformProcessInfoServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.elevator.flc.api.dto.InformProcessInfoDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 流程记录表
 *
 * @author system_generator
 * @date 2021-12-27
 */
@RestController
@Api(tags = "流程记录表Api")
@RequestMapping(value = "/inform-process-info")
public class InformProcessInfoController extends BaseController {

    @Autowired
    InformProcessInfoServiceImpl informProcessInfoServiceImpl;

    /**
     * 根据sequenceNbr查询
     *
	 * @param processId  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{processId}")
	@ApiOperation(httpMethod = "GET",value = "根据流程id查询相关流程信息",  notes = "根据流程id查询相关流程信息")
	public ResponseModel<List<InformProcessInfo>> selectByProcessId(@PathVariable String processId) {
		List<InformProcessInfo> result = informProcessInfoServiceImpl.list(new LambdaQueryWrapper<InformProcessInfo>().eq(InformProcessInfo::getProcessId,processId).eq(InformProcessInfo::getIsDelete,false).orderByDesc(InformProcessInfo::getRecDate));
	    return ResponseHelper.buildResponse(result);
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "通话记录附件分页查询",  notes = "通话记录附件分页查询")
	public ResponseModel<Page<InformProcessInfoDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<InformProcessInfoDto> page = new Page<InformProcessInfoDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(informProcessInfoServiceImpl.queryForInformProcessInfoPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "通话记录附件列表全部数据查询",   notes = "通话记录附件列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<InformProcessInfoDto>> selectForList() {
	    return ResponseHelper.buildResponse(informProcessInfoServiceImpl.queryForInformProcessInfoList());
	}
}
