package com.yeejoin.amos.boot.module.common.biz.refresh.dispatch;

import com.yeejoin.amos.boot.module.common.api.entity.TzsDataRefreshMessage;
import com.yeejoin.amos.boot.module.common.api.service.IDataRefreshDispatch;
import com.yeejoin.amos.boot.module.common.api.service.IDataRefreshHandler;
import com.yeejoin.amos.boot.module.common.biz.constats.Constants;
import com.yeejoin.amos.boot.module.common.biz.refresh.factory.RefreshHandlerFactory;
import com.yeejoin.amos.boot.module.common.biz.service.impl.TzsDataRefreshMessageServiceImpl;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

@Component
@RequiredArgsConstructor
@Slf4j
public class DataRefreshDispatcher implements IDataRefreshDispatch {

    private final RefreshHandlerFactory refreshHandlerFactory;
    private final TzsDataRefreshMessageServiceImpl refreshMessageService;

    @Override
    @Async
    public void doDispatch(String dataType, List<TzsDataRefreshMessage> messages) {
        IDataRefreshHandler dataRefreshHandler = refreshHandlerFactory.getRefreshHandler(dataType);
        messages.forEach(message -> {
            try {
                dataRefreshHandler.doRefresh(message);
                markRefreshSuccess(message);
            } catch (Exception e) {
                log.error("三库数据刷新执行失败，消息内容：{}, 错误日志：{}", message, e.getMessage(), e);
                message.setErrorMsg(e.getMessage());
                markRefreshFailure(message);
            }
        });
    }

    private void markRefreshSuccess(TzsDataRefreshMessage message) {
        updateMessageStatus(message, Constants.REFRESH_STATUS_SUCCESS);
    }

    private void markRefreshFailure(TzsDataRefreshMessage message) {
        updateMessageStatus(message, Constants.REFRESH_STATUS_FAILURE);
    }

    private void updateMessageStatus(TzsDataRefreshMessage message, Integer status) {
        message.setStatus(status);
        message.setRecDate(new Date());
        refreshMessageService.saveOrUpdate(message);
    }
}
