package com.yeejoin.amos.boot.module.jg.api.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.dto.JgMaintainNoticeDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgMaintainNotice;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 接口类
 *
 * @author system_generator
 * @date 2023-12-12
 */
public interface IJgMaintainNoticeService extends IService<JgMaintainNotice> {

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return 维修告知
     */
    Map<String, Map<String, Object>> queryBySequenceNbr(Long sequenceNbr, CompanyBo companyBo);

    /**
     * 更新维修告知
     *
     * @param noticeDto 维修告知
     * @param op        操作类型
     */
    JgMaintainNoticeDto updateMaintainNotice(String submitType, JgMaintainNoticeDto noticeDto, String op, ReginParams reginParams);

    /**
     * 分页查询
     *
     * @param page  分页对象
     * @param model 查询参数
     * @return 维修告知列表
     */
    Page<Map<String, Object>> queryForJgMaintainNoticePage(Page<JgMaintainNotice> page, String sort, JgMaintainNoticeDto model, ReginParams reginParams, String client);

    /**
     * 保存维修告知单
     *
     * @param model      数据
     * @param submitType 保存类型
     */
    List<JgMaintainNotice> saveNotice(String submitType, Map<String, Object> model, ReginParams reginParams);

    /**
     * 打印告知单
     *
     * @param sequenceNbr 主键
     * @return pdf文件路径
     */
    void generateMaintainNoticeReport(Long sequenceNbr,HttpServletResponse response);

    boolean deleteBySequenceNbr(Long[] sequenceNbr);

    /**
     * 作废申请
     * @param sequenceNbr 业务唯一标识
     * @param cancelReason 作废原因
     * @return JgInstallationNoticeDto
     */
    JgMaintainNotice cancelApplication(Long sequenceNbr, String cancelReason);
}
