package com.yeejoin.amos.boot.module.tcm.biz.utils;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * @Author: xl
 * @Description:
 * @Date: 2022/8/4 9:08
 */
public class StringUtils {

    public static StringJoiner getWhereSql(String operator, Map<String, String> map){
        StringJoiner stringJoiner = new StringJoiner(" " + operator +" ");
        for (Map.Entry entry :map.entrySet()) {
            stringJoiner.add(entry.getKey() + "=" + str2sqlValue(entry.getValue().toString()));
        }
        return stringJoiner;
    }

    public static String str2sqlValue(String str){
        return "'" + str + "'";
    }

    public static String getStrByPattern(String str, Pattern reg){
        Matcher mat = reg.matcher(str);
        while (mat.find()) {
            return mat.group(0);
        }
        return "";
    }
    /**
     * 去掉前后中括号，按逗号分割，去掉空格和空字符串
     */
    public static List<String> splitAndClean(String str) {
        if (str == null || str.trim().isEmpty()) {
            return Collections.emptyList();
        }
        str = str.replaceAll("^\\[|\\]$", "").trim();
        return Arrays.stream(str.split(","))
                .map(String::trim)
                .filter(s -> !s.isEmpty())
                .collect(Collectors.toList());
    }
}
