package com.yeejoin.amos.api.openapi.enums;


import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@AllArgsConstructor
@Getter
public enum CylinderUnitFieldEnum {
    unitId(true, true),
    regionCode(true, false),
    regionName(true, false),
    unitName(true, true),
    creditCode(true, true),
    address(true, false),
    unitPerson(true, false),
    personMobilePhone(true, false),
    personTelephone(true, false),
    securityAdm(true, false),
    securityAdmPhone(true, false),
    postalCode(true, false),
    syncDate(true, false),
    syncState(true, false),
    qualificationFile(true, false),
    useRegisterFile(true, false),
    deviceSummaryFile(true, false);

    private final boolean isRequire;
    private final boolean isUnique;

    public static List<String> getAllRequireKeys() {
        return Arrays.stream(values()).filter(e -> e.isRequire).map(Enum::name).collect(Collectors.toList());
    }

    public static List<String> getAllUniqueKeys() {
        return Arrays.stream(values()).filter(e -> e.isUnique).map(Enum::name).collect(Collectors.toList());
    }
}
