package com.yeejoin.amos.api.openapi.face.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;


@EqualsAndHashCode(callSuper = true)
@Data
public class TmCylinderFillingCheckModel extends CylinderAbstractBaseModel {
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "检查时间")
	private Date inspectionDate;

	@ApiModelProperty(value = "瓶体未出现鼓包变形或泄漏等严重缺陷")
	private String isNoBulgingOrLeakage;

	@ApiModelProperty(value = "瓶内压力正常")
	private String isPressureNormal;

	@ApiModelProperty(value = "瓶体温度没有异常升高的迹象")
	private String isTemperatureNormal;

	@ApiModelProperty(value = "瓶阀及其与瓶口连接的密封良好")
	private String valveSealIsGood;

	@ApiModelProperty(value = "气瓶粘贴警示标签和充装标签)")
	private String hasWarningAndFillingLabels;

	@ApiModelProperty(value = "充装量复秤未超重")
	private String reweighedWithinLimit;

	@ApiModelProperty(value = "瓶内压力(充装量)及质量符合安全技术规范及相关标准的要求")
	private String pressureAndMassMeetRegulations;

	@ApiModelProperty(value = "瓶帽、充装标签、警示标签完整")
	private String capsAndLabelsAreIntact;

	@ApiModelProperty(value = "瓶阀出气口螺纹及其密封面良好")
	private String valveSealedWell;

	@ApiModelProperty(value = "静置后压力符合规定")
	private String pressureAfterRestingComplies;

	@ApiModelProperty(value = "气瓶未发生泄漏等问题")
	private String noLeakageIssuesDetected;

	@ApiModelProperty(value = "处理结果是否合格")
	private String isTreatmentResultQualified;

	@ApiModelProperty(value = "充装量（压力或质量）符合要求")
	private String fillingAmountMeetsRequirement;

	@ApiModelProperty(value = "密封良好无泄漏")
	private String sealsIntactNoLeakage;

	@ApiModelProperty(value = "气瓶无变形等缺陷")
	private String noDeformationOrDefects;

	@ApiModelProperty(value = "瓶体温升无异常")
	private String temperatureRiseNormal;

	@ApiModelProperty(value = "气瓶附件完整齐全")
	private String cylinderAccessoriesComplete;

	@ApiModelProperty(value = "阀门已关闭,管路及各附件无漏气")
	private String valveClosedNoLeakageInPipingAndAccessories;

	@ApiModelProperty(value = "气瓶外观无结霜、结露")
	private String noFrostOrCondensationOnCylinder;
}
