package com.yeejoin.amos.api.openapi.face.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 单位许可信息表
 *
 * @author duanwei
 * @date 2022-11-30
 */
@Data
@ApiModel(value="TzUgpUnitLicence对象", description="单位许可信息表")
public class UnitLicenceModel {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "自增主键")
    private Long sequenceNbr;

    @ApiModelProperty(value = "单位编码")
    private String unitCode;

    @ApiModelProperty(value = "单位名称")
    private String unitName;

    @ApiModelProperty(value = "许可地址")
    private String licAddress;

    @ApiModelProperty(value = "证书类型")
    private String certType;

    @ApiModelProperty(value = "证书类型code")
    private String certTypeCode;

    @ApiModelProperty(value = "证书编号")
    private String certNo;

    @ApiModelProperty(value = "有效期至")
    private Date expiryDate;

    @ApiModelProperty(value = "发证日期")
    private Date issueDate;

    @ApiModelProperty(value = "发证机关")
    private String approvedOrgan;

    @ApiModelProperty(value = "发证机关code")
    private String approvedOrganCode;

    @ApiModelProperty(value = "变更日期")
    private Date changeDate;

    @ApiModelProperty(value = "许可方式/许可状态")
    private String applyType;

    @ApiModelProperty(value = "许可方式/许可状态code")
    private String applyTypeCode;

    @ApiModelProperty(value = "许可评审方式")
    private String appraisalType;

    @ApiModelProperty(value = "许可评审方式code")
    private String appraisalTypeCode;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "许可项目/检验类型/设备品种编码")
    private String itemCode;

    @ApiModelProperty(value = "许可项目/检验类型/设备品种")
    private String itemCodeName;

    @ApiModelProperty(value = "许可子项目/检验项目/充装介质类别code")
    private String subItemCode;

    @ApiModelProperty(value = "许可子项目/检验项目/充装介质类别")
    private String subItemName;

    @ApiModelProperty(value = "许可参数/充装介质名称")
    private String parameter;

    @ApiModelProperty(value = "参数code")
    private String parameterCode;

    @ApiModelProperty(value = "固定检验地址")
    private String itemAddress;

}
