package com.yeejoin.amos.boot.module.elevator.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 救援回访DTO
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="DispatchSaveFeedbackDto", description="救援回访DTO")
public class DispatchSaveFeedbackDto extends BaseDto {

   private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "警情id")
    private Long alertId;

    @ApiModelProperty(value = "求援人")
    private String emergency;

    @ApiModelProperty(value = "求援电话")
    private String emergencyCall;

    @ApiModelProperty(value = "救援回访时间")
    private Date saveFeedbackTime;

    @ApiModelProperty(value = "救援回访人")
    private String saveFeedbackUser;

    @ApiModelProperty(value = "救援回访人Id")
    private String saveFeedbackUid;

    @ApiModelProperty(value = "救援回访结果")
    private String saveFeedbackResult;

   @ApiModelProperty(value = "救援回访反馈方式Code")
   private String emergencyFeedbackCode;

    @ApiModelProperty(value = "响应人")
    private String responseUserName;

    @ApiModelProperty(value = "响应人电话")
    private String responseUserTel;

    @ApiModelProperty(value = "维修反馈方式Code")
    private String feedbackCode;

    @ApiModelProperty(value = "维修反馈方式")
    private String feedbackType;

    @ApiModelProperty(value = "维修结果")
    private String fixResult;

    @ApiModelProperty(value = "维修完成时间")
    private Date feedbackFinishTime;

    @ApiModelProperty(value = "维修反馈人id")
    private String feedbackUid;

    @ApiModelProperty(value = "维修反馈人")
    private String feedbackUname;

    @ApiModelProperty(value = "电梯故障原因分类")
    private String errorResult;

    @ApiModelProperty(value = "备注")
    private String Remark;

    @ApiModelProperty(value = "回访时间")
    private Date feedbackTime;

    @ApiModelProperty(value = "维修备注")
    private String fixRemark;


 public DispatchSaveFeedbackDto() {

    }
}
