package com.yeejoin.amos.boot.module.common.api.dto;

import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 安全追溯-压力容器
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@Group("2000")
public class VesselTechParamsDefine implements ITechParamDefine {


    @TechnicalParameter(key = "singleBottleVolume", label = "单瓶容积", equCategory = {"2300"}, tags = "vehicleCylinder", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "L")
    private BigDecimal singleBottleVolume;

    @TechnicalParameter(key = "chargingMedium", label = "充装介质", equCategory = {"2300"}, tags = "vehicleCylinder", type = TechnicalParameter.ParamType.STRING)
    private String chargingMedium;

    @TechnicalParameter(key = "nominalWorkingPressure", label = "公称工作压力", equCategory = {"2300"}, tags = "vehicleCylinder", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "MPa")
    private BigDecimal nominalWorkingPressure;

    @TechnicalParameter(key = "specification", label = "规格", equCategory = {"2300"}, type = TechnicalParameter.ParamType.STRING)
    private String specification;

    @TechnicalParameter(key = "modelNumber", label = "型号", equCategory = {"2300"}, type = TechnicalParameter.ParamType.STRING)
    private String modelNumber;

    @TechnicalParameter(key = "wallThickness", label = "壁厚", equCategory = {"2300"}, type = TechnicalParameter.ParamType.BIG_DECIMAL)
    private BigDecimal wallThickness;

    @TechnicalParameter(key = "ratedQuality", label = "额定质量", equCategory = {"2300"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "kg")
    private BigDecimal ratedQuality;

    @TechnicalParameter(key = "ambientTemperature", label = "使用环境温度", equCategory = {"2300"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "℃")
    private BigDecimal ambientTemperature;

    @TechnicalParameter(key = "outsideDiameter", label = "外径", equCategory = {"2300"}, type = TechnicalParameter.ParamType.BIG_DECIMAL)
    private BigDecimal outsideDiameter;

    @TechnicalParameter(key = "qpLossless", label = "无损检测方法（气瓶）", equCategory = {"2300"}, type = TechnicalParameter.ParamType.STRING)
    private String qpLossless;

    @TechnicalParameter(key = "length", label = "长度", equCategory = {"2300", "2200"}, type = TechnicalParameter.ParamType.BIG_DECIMAL)
    private BigDecimal length;

    @TechnicalParameter(key = "endPlug", label = "材料（端塞）", equCategory = {"2300"}, type = TechnicalParameter.ParamType.STRING)
    private String endPlug;

    @TechnicalParameter(key = "piping", label = "材料（管路）", equCategory = {"2300"}, type = TechnicalParameter.ParamType.STRING)
    private String piping;

    @TechnicalParameter(key = "qpRatio", label = "无损检测比例（气瓶）", equCategory = {"2300"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "%")
    private BigDecimal qpRatio;

    @TechnicalParameter(key = "bottleBody", label = "材料（瓶体）", equCategory = {"2300"}, type = TechnicalParameter.ParamType.STRING)
    private String bottleBody;

    @TechnicalParameter(key = "qpPressure", label = "耐压试验压力（气瓶）", equCategory = {"2300"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "MPa")
    private BigDecimal qpPressure;

    @TechnicalParameter(key = "glRatio", label = "无损检测比例（管路）", equCategory = {"2300"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "%")
    private BigDecimal glRatio;


    @TechnicalParameter(key = "qpAirTightness", label = "气密性试验压力（气瓶）", equCategory = {"2300"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "MPa")
    private BigDecimal qpAirTightness;

    @TechnicalParameter(key = "glLossless", label = "无损检测方法（管路）", equCategory = {"2300"}, type = TechnicalParameter.ParamType.STRING)
    private String glLossless;

    @TechnicalParameter(key = "heatTreatmentMethod", label = "热处理方式", equCategory = {"2300"}, type = TechnicalParameter.ParamType.STRING, unit = "%")
    private String heatTreatmentMethod;

    @TechnicalParameter(key = "glPressure", label = "耐压试验压力（管路）", equCategory = {"2300"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "MPa")
    private BigDecimal glPressure;

    @TechnicalParameter(key = "installationPosition", label = "气瓶安装位置", equCategory = {"2300"}, type = TechnicalParameter.ParamType.STRING)
    private String installationPosition;

    @TechnicalParameter(key = "displacementPressure", label = "气体置换后压力", equCategory = {"2300"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "MPa")
    private BigDecimal displacementPressure;

    @TechnicalParameter(key = "qpHeatTreatmentTemperature", label = "热处理温度", equCategory = {"2300", "2100"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "℃")
    private BigDecimal qpHeatTreatmentTemperature;

    @TechnicalParameter(key = "glAirTightness", label = "气密性试验压力（管路）", equCategory = {"2300"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "MPa")
    private BigDecimal glAirTightness;

    @TechnicalParameter(key = "oxygen", label = "瓶体内含氧量", equCategory = {"2300"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "%")
    private BigDecimal oxygen;


    @TechnicalParameter(key = "containerVolume", label = "容器容积", equCategory = {"2100"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m³")
    private BigDecimal containerVolume;

    @TechnicalParameter(key = "pressureVesselDiameter", label = "容器内径", equCategory = {"2100", "2200"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "mm")
    private BigDecimal pressureVesselDiameter;

    @TechnicalParameter(key = "height", label = "容器高(长)", equCategory = {"2100"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "mm")
    private BigDecimal height;

    @TechnicalParameter(key = "materialCylinderShell", label = "材料（筒体(球壳)）", equCategory = {"2100"}, type = TechnicalParameter.ParamType.STRING)
    private String materialCylinderShell;

    @TechnicalParameter(key = "pressureMaterialHead", label = "材料（封头）", equCategory = {"2100", "2200"}, type = TechnicalParameter.ParamType.STRING)
    private String pressureMaterialHead;

    @TechnicalParameter(key = "pressureMaterialLining", label = "材料（衬里）", equCategory = {"2100"}, type = TechnicalParameter.ParamType.STRING)
    private String pressureMaterialLining;

    @TechnicalParameter(key = "materialJacket", label = "材料（夹套）", equCategory = {"2100"}, type = TechnicalParameter.ParamType.STRING)
    private String materialJacket;

    @TechnicalParameter(key = "thickness", label = "厚度（筒体(球壳)）", equCategory = {"2100"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "mm")
    private BigDecimal thickness;

    @TechnicalParameter(key = "fixedHead", label = "厚度（封头）", equCategory = {"2100", "2200"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "mm")
    private BigDecimal fixedHead;

    @TechnicalParameter(key = "fixedLining", label = "厚度（衬里）", equCategory = {"2100"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "mm")
    private BigDecimal fixedLining;

    @TechnicalParameter(key = "fixedJacket", label = "厚度（夹套）", equCategory = {"2100"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "mm")
    private BigDecimal fixedJacket;

    @TechnicalParameter(key = "selfWeight", label = "容器自重", equCategory = {"2100"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "kg")
    private BigDecimal selfWeight;

    @TechnicalParameter(key = "mediumWeight", label = "盛装介质重量", equCategory = {"2100"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "kg")
    private BigDecimal mediumWeight;

    @TechnicalParameter(key = "pressureHousingPath", label = "设计压力（壳程）", equCategory = {"2100"}, type = TechnicalParameter.ParamType.STRING)
    private String pressureHousingPath;

    @TechnicalParameter(key = "pressurePipe", label = "设计压力（管程）", equCategory = {"2100"}, type = TechnicalParameter.ParamType.STRING)
    private String pressurePipe;

    @TechnicalParameter(key = "pressureJacket", label = "设计压力（夹套）", equCategory = {"2100"}, type = TechnicalParameter.ParamType.STRING)
    private String pressureJacket;

    @TechnicalParameter(key = "temperatureShell", label = "设计温度（壳程）", equCategory = {"2100"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "℃")
    private BigDecimal temperatureShell;

    @TechnicalParameter(key = "temperaturePipe", label = "设计温度（管程）", equCategory = {"2100"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "℃")
    private BigDecimal temperaturePipe;

    @TechnicalParameter(key = "temperatureJacket", label = "设计温度（夹套）", equCategory = {"2100"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "℃")
    private BigDecimal temperatureJacket;

    @TechnicalParameter(key = "maxPressureShell", label = "最高允许工作压力（壳程）", equCategory = {"2100"}, type = TechnicalParameter.ParamType.STRING)
    private String maxPressureShell;

    @TechnicalParameter(key = "maxPressurePipe", label = "最高允许工作压力（管程）", equCategory = {"2100"}, type = TechnicalParameter.ParamType.STRING)
    private String maxPressurePipe;

    @TechnicalParameter(key = "maxPressureJacket", label = "最高允许工作压力（夹套）", equCategory = {"2100"}, type = TechnicalParameter.ParamType.STRING)
    private String maxPressureJacket;

    @TechnicalParameter(key = "mediumShell", label = "介质（壳程）", equCategory = {"2100"}, type = TechnicalParameter.ParamType.STRING)
    private String mediumShell;


    @TechnicalParameter(key = "mediumPipe", label = "介质（管程）", equCategory = {"2100"}, type = TechnicalParameter.ParamType.STRING)
    private String mediumPipe;


    @TechnicalParameter(key = "mediumJacket", label = "介质（夹套）", equCategory = {"2100"}, type = TechnicalParameter.ParamType.STRING)
    private String mediumJacket;


    @TechnicalParameter(key = "mainStructureType", label = "主体结构型式", equCategory = {"2100", "2200"}, type = TechnicalParameter.ParamType.STRING, dictCode = "RQJG")
    private String mainStructureType;


    @TechnicalParameter(key = "support", label = "支座型式", equCategory = {"2100", "2200"}, type = TechnicalParameter.ParamType.STRING)
    private String support;


    @TechnicalParameter(key = "installation", label = "安装型式", equCategory = {"2100", "2200",}, type = TechnicalParameter.ParamType.STRING)
    private String installation;


    @TechnicalParameter(key = "insulation", label = "保温绝热方式", equCategory = {"2100", "2200"}, type = TechnicalParameter.ParamType.STRING)
    private String insulation;


    @TechnicalParameter(key = "checkLossless", label = "无损检测方法", equCategory = {"2100"}, type = TechnicalParameter.ParamType.STRING, dictCode = "RQJCFF")
    private String checkLossless;


    @TechnicalParameter(key = "withstandVoltage", label = "耐压试验种类", equCategory = {"2100"}, type = TechnicalParameter.ParamType.STRING)
    private String withstandVoltage;


    @TechnicalParameter(key = "leakage", label = "泄漏试验种类", equCategory = {"2100"}, type = TechnicalParameter.ParamType.STRING)
    private String leakage;


    @TechnicalParameter(key = "withstandPressureTest", label = "耐压试验压力", equCategory = {"2100"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "MPa")
    private BigDecimal withstandPressureTest;


    @TechnicalParameter(key = "leakPressure", label = "泄漏试验压力", equCategory = {"2100"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "MPa")
    private BigDecimal leakPressure;


    @TechnicalParameter(key = "container", label = "容器型号", equCategory = {"2200"}, type = TechnicalParameter.ParamType.STRING)
    private String container;


    @TechnicalParameter(key = "carNum", label = "罐车编号", equCategory = {"2200"}, type = TechnicalParameter.ParamType.STRING)
    private String carNum;


    @TechnicalParameter(key = "volume", label = "容积", equCategory = {"2200"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "L")
    private BigDecimal volume;


    @TechnicalParameter(key = "maxFill", label = "最大充装量", equCategory = {"2200"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "kg")
    private BigDecimal maxFill;


    @TechnicalParameter(key = "designPressure", label = "设计压力", equCategory = {"2200"}, type = TechnicalParameter.ParamType.STRING)
    private String designPressure;


    @TechnicalParameter(key = "designTemperature", label = "设计温度", equCategory = {"2200"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "℃")
    private BigDecimal designTemperature;


    @TechnicalParameter(key = "workingPressure", label = "工作压力", equCategory = {"2200"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "MPa")
    private BigDecimal workingPressure;


    @TechnicalParameter(key = "workTemperature", label = "工作温度", equCategory = {"2200"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "℃")
    private BigDecimal workTemperature;


    @TechnicalParameter(key = "materialCylinder", label = "材料（筒体）", equCategory = {"2200"}, type = TechnicalParameter.ParamType.STRING)
    private String materialCylinder;


    @TechnicalParameter(key = "thicknessCylinder", label = "厚度（筒体）", equCategory = {"2200"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "mm")
    private BigDecimal thicknessCylinder;


    @TechnicalParameter(key = "corrosionMargin", label = "腐蚀裕量", equCategory = {"2200"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "mm")
    private BigDecimal corrosionMargin;


    @TechnicalParameter(key = "medium", label = "介质", equCategory = {"2200"}, type = TechnicalParameter.ParamType.STRING)
    private String medium;


    @TechnicalParameter(key = "oxygenChamber", label = "氧舱品种", equCategory = {"2400"}, type = TechnicalParameter.ParamType.STRING)
    private String oxygenChamber;


    @TechnicalParameter(key = "ratedEntryCapacity", label = "额定进舱人数", equCategory = {"2400"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "人")
    private BigDecimal ratedEntryCapacity;


    @TechnicalParameter(key = "chamberMain", label = "主体结构", equCategory = {"2400"}, type = TechnicalParameter.ParamType.STRING)
    private String chamberMain;


    @TechnicalParameter(key = "chamberPressure", label = "压力", equCategory = {"2400"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "MPa")
    private BigDecimal chamberPressure;


    @TechnicalParameter(key = "temperature", label = "温度", equCategory = {"2400"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "℃")
    private BigDecimal temperature;


    @TechnicalParameter(key = "pressureMedium", label = "压力介质", equCategory = {"2400"}, type = TechnicalParameter.ParamType.STRING)
    private String pressureMedium;


    @TechnicalParameter(key = "perCapitaCabinCapacity", label = "人均舱容", equCategory = {"2400"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m³")
    private BigDecimal perCapitaCabinCapacity;


    @TechnicalParameter(key = "losslessRatio", label = "无损检测比例", equCategory = {"2100", "2200"}, type = TechnicalParameter.ParamType.BIG_DECIMAL)
    private BigDecimal losslessRatio;


    @TechnicalParameter(key = "losslessMethod", label = "无损检测方法", equCategory = {"2200"}, type = TechnicalParameter.ParamType.STRING)
    private String losslessMethod;


    @TechnicalParameter(key = "yearReportNo", label = "年度检查报告编号", equCategory = {"2100", "2400"}, type = TechnicalParameter.ParamType.STRING)
    private String yearReportNo;


    @TechnicalParameter(key = "airTightnessPressure", label = "气密性试验压力", equCategory = {"2200", "2400"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "MPa")
    private BigDecimal airTightnessPressure;


    @TechnicalParameter(key = "airTightnessMedium", label = "气密性试验介质", equCategory = {"2200"}, type = TechnicalParameter.ParamType.STRING)
    private String airTightnessMedium;


    @TechnicalParameter(key = "isElectricalMod", label = "是否电气改造", equCategory = {"2400"}, type = TechnicalParameter.ParamType.STRING)
    private String isElectricalMod;


    @TechnicalParameter(key = "setPressure", label = "安全阀整定压力", equCategory = {"2200"}, type = TechnicalParameter.ParamType.STRING)
    private String setPressure;

}
